/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwright.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.playwright.PlaywrightManager;
import com.azure.resourcemanager.playwright.fluent.PlaywrightWorkspaceQuotasClient;
import com.azure.resourcemanager.playwright.fluent.models.PlaywrightWorkspaceQuotaInner;
import com.azure.resourcemanager.playwright.implementation.PlaywrightWorkspaceQuotaImpl;
import com.azure.resourcemanager.playwright.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.playwright.models.PlaywrightWorkspaceQuota;
import com.azure.resourcemanager.playwright.models.PlaywrightWorkspaceQuotas;
import com.azure.resourcemanager.playwright.models.QuotaName;

public final class PlaywrightWorkspaceQuotasImpl
implements PlaywrightWorkspaceQuotas {
    private static final ClientLogger LOGGER = new ClientLogger(PlaywrightWorkspaceQuotasImpl.class);
    private final PlaywrightWorkspaceQuotasClient innerClient;
    private final PlaywrightManager serviceManager;

    public PlaywrightWorkspaceQuotasImpl(PlaywrightWorkspaceQuotasClient innerClient, PlaywrightManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PlaywrightWorkspaceQuota> getWithResponse(String resourceGroupName, String playwrightWorkspaceName, QuotaName quotaName, Context context) {
        Response<PlaywrightWorkspaceQuotaInner> inner = this.serviceClient().getWithResponse(resourceGroupName, playwrightWorkspaceName, quotaName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PlaywrightWorkspaceQuotaImpl((PlaywrightWorkspaceQuotaInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PlaywrightWorkspaceQuota get(String resourceGroupName, String playwrightWorkspaceName, QuotaName quotaName) {
        PlaywrightWorkspaceQuotaInner inner = this.serviceClient().get(resourceGroupName, playwrightWorkspaceName, quotaName);
        if (inner != null) {
            return new PlaywrightWorkspaceQuotaImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PlaywrightWorkspaceQuota> listByPlaywrightWorkspace(String resourceGroupName, String playwrightWorkspaceName) {
        PagedIterable<PlaywrightWorkspaceQuotaInner> inner = this.serviceClient().listByPlaywrightWorkspace(resourceGroupName, playwrightWorkspaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PlaywrightWorkspaceQuotaImpl((PlaywrightWorkspaceQuotaInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PlaywrightWorkspaceQuota> listByPlaywrightWorkspace(String resourceGroupName, String playwrightWorkspaceName, Context context) {
        PagedIterable<PlaywrightWorkspaceQuotaInner> inner = this.serviceClient().listByPlaywrightWorkspace(resourceGroupName, playwrightWorkspaceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PlaywrightWorkspaceQuotaImpl((PlaywrightWorkspaceQuotaInner)((Object)inner1), this.manager()));
    }

    private PlaywrightWorkspaceQuotasClient serviceClient() {
        return this.innerClient;
    }

    private PlaywrightManager manager() {
        return this.serviceManager;
    }
}

