/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwright.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.playwright.fluent.PlaywrightWorkspaceQuotasClient;
import com.azure.resourcemanager.playwright.fluent.models.PlaywrightWorkspaceQuotaInner;
import com.azure.resourcemanager.playwright.implementation.PlaywrightManagementClientImpl;
import com.azure.resourcemanager.playwright.implementation.models.PlaywrightWorkspaceQuotaListResult;
import com.azure.resourcemanager.playwright.models.QuotaName;
import reactor.core.publisher.Mono;

public final class PlaywrightWorkspaceQuotasClientImpl
implements PlaywrightWorkspaceQuotasClient {
    private final PlaywrightWorkspaceQuotasService service;
    private final PlaywrightManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(PlaywrightWorkspaceQuotasClientImpl.class);

    PlaywrightWorkspaceQuotasClientImpl(PlaywrightManagementClientImpl client) {
        this.service = (PlaywrightWorkspaceQuotasService)RestProxy.create(PlaywrightWorkspaceQuotasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PlaywrightWorkspaceQuotaInner>> getWithResponseAsync(String resourceGroupName, String playwrightWorkspaceName, QuotaName quotaName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (playwrightWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter playwrightWorkspaceName is required and cannot be null."));
        }
        if (quotaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter quotaName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, playwrightWorkspaceName, quotaName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PlaywrightWorkspaceQuotaInner> getAsync(String resourceGroupName, String playwrightWorkspaceName, QuotaName quotaName) {
        return this.getWithResponseAsync(resourceGroupName, playwrightWorkspaceName, quotaName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((PlaywrightWorkspaceQuotaInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PlaywrightWorkspaceQuotaInner> getWithResponse(String resourceGroupName, String playwrightWorkspaceName, QuotaName quotaName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (playwrightWorkspaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter playwrightWorkspaceName is required and cannot be null."));
        }
        if (quotaName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter quotaName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, playwrightWorkspaceName, quotaName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PlaywrightWorkspaceQuotaInner get(String resourceGroupName, String playwrightWorkspaceName, QuotaName quotaName) {
        return (PlaywrightWorkspaceQuotaInner)((Object)this.getWithResponse(resourceGroupName, playwrightWorkspaceName, quotaName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PlaywrightWorkspaceQuotaInner>> listByPlaywrightWorkspaceSinglePageAsync(String resourceGroupName, String playwrightWorkspaceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (playwrightWorkspaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter playwrightWorkspaceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByPlaywrightWorkspace(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, playwrightWorkspaceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).value(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PlaywrightWorkspaceQuotaInner> listByPlaywrightWorkspaceAsync(String resourceGroupName, String playwrightWorkspaceName) {
        return new PagedFlux(() -> this.listByPlaywrightWorkspaceSinglePageAsync(resourceGroupName, playwrightWorkspaceName), nextLink -> this.listByPlaywrightWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PlaywrightWorkspaceQuotaInner> listByPlaywrightWorkspaceSinglePage(String resourceGroupName, String playwrightWorkspaceName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (playwrightWorkspaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter playwrightWorkspaceName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PlaywrightWorkspaceQuotaListResult> res = this.service.listByPlaywrightWorkspaceSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, playwrightWorkspaceName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).value(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PlaywrightWorkspaceQuotaInner> listByPlaywrightWorkspaceSinglePage(String resourceGroupName, String playwrightWorkspaceName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (playwrightWorkspaceName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter playwrightWorkspaceName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PlaywrightWorkspaceQuotaListResult> res = this.service.listByPlaywrightWorkspaceSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, playwrightWorkspaceName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).value(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PlaywrightWorkspaceQuotaInner> listByPlaywrightWorkspace(String resourceGroupName, String playwrightWorkspaceName) {
        return new PagedIterable(() -> this.listByPlaywrightWorkspaceSinglePage(resourceGroupName, playwrightWorkspaceName), nextLink -> this.listByPlaywrightWorkspaceNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PlaywrightWorkspaceQuotaInner> listByPlaywrightWorkspace(String resourceGroupName, String playwrightWorkspaceName, Context context) {
        return new PagedIterable(() -> this.listByPlaywrightWorkspaceSinglePage(resourceGroupName, playwrightWorkspaceName, context), nextLink -> this.listByPlaywrightWorkspaceNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PlaywrightWorkspaceQuotaInner>> listByPlaywrightWorkspaceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByPlaywrightWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).value(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PlaywrightWorkspaceQuotaInner> listByPlaywrightWorkspaceNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PlaywrightWorkspaceQuotaListResult> res = this.service.listByPlaywrightWorkspaceNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).value(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<PlaywrightWorkspaceQuotaInner> listByPlaywrightWorkspaceNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<PlaywrightWorkspaceQuotaListResult> res = this.service.listByPlaywrightWorkspaceNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).value(), ((PlaywrightWorkspaceQuotaListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="PlaywrightManagementClientPlaywrightWorkspaceQuotas")
    public static interface PlaywrightWorkspaceQuotasService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/playwrightWorkspaces/{playwrightWorkspaceName}/quotas/{quotaName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PlaywrightWorkspaceQuotaInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="playwrightWorkspaceName") String var5, @PathParam(value="quotaName") QuotaName var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/playwrightWorkspaces/{playwrightWorkspaceName}/quotas/{quotaName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PlaywrightWorkspaceQuotaInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="playwrightWorkspaceName") String var5, @PathParam(value="quotaName") QuotaName var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/playwrightWorkspaces/{playwrightWorkspaceName}/quotas")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PlaywrightWorkspaceQuotaListResult>> listByPlaywrightWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="playwrightWorkspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/playwrightWorkspaces/{playwrightWorkspaceName}/quotas")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PlaywrightWorkspaceQuotaListResult> listByPlaywrightWorkspaceSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="playwrightWorkspaceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PlaywrightWorkspaceQuotaListResult>> listByPlaywrightWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<PlaywrightWorkspaceQuotaListResult> listByPlaywrightWorkspaceNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

