/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.playwright.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.playwright.models.PlaywrightWorkspaceProperties;
import java.io.IOException;
import java.util.Map;

public final class PlaywrightWorkspaceInner
extends Resource {
    private PlaywrightWorkspaceProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public PlaywrightWorkspaceProperties properties() {
        return this.properties;
    }

    public PlaywrightWorkspaceInner withProperties(PlaywrightWorkspaceProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public PlaywrightWorkspaceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public PlaywrightWorkspaceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static PlaywrightWorkspaceInner fromJson(JsonReader jsonReader) throws IOException {
        return (PlaywrightWorkspaceInner)((Object)jsonReader.readObject(reader -> {
            PlaywrightWorkspaceInner deserializedPlaywrightWorkspaceInner = new PlaywrightWorkspaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPlaywrightWorkspaceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPlaywrightWorkspaceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPlaywrightWorkspaceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPlaywrightWorkspaceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPlaywrightWorkspaceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPlaywrightWorkspaceInner.properties = PlaywrightWorkspaceProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedPlaywrightWorkspaceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPlaywrightWorkspaceInner;
        }));
    }
}

