/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.planetarycomputer.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.planetarycomputer.models.ManagedServiceIdentityType;
import com.azure.resourcemanager.planetarycomputer.models.UserAssignedIdentity;
import java.io.IOException;
import java.util.Map;

public final class ManagedServiceIdentityUpdate
implements JsonSerializable<ManagedServiceIdentityUpdate> {
    private ManagedServiceIdentityType type;
    private Map<String, UserAssignedIdentity> userAssignedIdentities;

    public ManagedServiceIdentityType type() {
        return this.type;
    }

    public ManagedServiceIdentityUpdate withType(ManagedServiceIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, UserAssignedIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public ManagedServiceIdentityUpdate withUserAssignedIdentities(Map<String, UserAssignedIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedServiceIdentityUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedServiceIdentityUpdate)jsonReader.readObject(reader -> {
            ManagedServiceIdentityUpdate deserializedManagedServiceIdentityUpdate = new ManagedServiceIdentityUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedManagedServiceIdentityUpdate.type = ManagedServiceIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedManagedServiceIdentityUpdate.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserAssignedIdentity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedServiceIdentityUpdate;
        });
    }
}

