/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.planetarycomputer.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.planetarycomputer.fluent.models.GeoCatalogInner;
import java.io.IOException;
import java.util.List;

public final class GeoCatalogListResult
implements JsonSerializable<GeoCatalogListResult> {
    private List<GeoCatalogInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(GeoCatalogListResult.class);

    private GeoCatalogListResult() {
    }

    public List<GeoCatalogInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model GeoCatalogListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static GeoCatalogListResult fromJson(JsonReader jsonReader) throws IOException {
        return (GeoCatalogListResult)jsonReader.readObject(reader -> {
            GeoCatalogListResult deserializedGeoCatalogListResult = new GeoCatalogListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedGeoCatalogListResult.value = value = reader.readArray(reader1 -> GeoCatalogInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedGeoCatalogListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGeoCatalogListResult;
        });
    }
}

