/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.VolumeInner;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.VolumeDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.VolumeProvisioningState;
import java.util.List;
import java.util.Map;

public interface Volume {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public Long allocatedSizeMiB();

    public List<String> attachedTo();

    public VolumeDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public VolumeProvisioningState provisioningState();

    public String serialNumber();

    public long sizeMiB();

    public String storageApplianceId();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public VolumeInner innerModel();

    public Update update();

    public Volume refresh();

    public Volume refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfNoneMatch {
            public Update withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIfMatch,
    UpdateStages.WithIfNoneMatch {
        public Volume apply();

        public Volume apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithStorageApplianceId {
            public WithCreate withStorageApplianceId(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithStorageApplianceId,
        WithIfMatch,
        WithIfNoneMatch {
            public Volume create();

            public Volume create(Context var1);
        }

        public static interface WithSizeMiB {
            public WithCreate withSizeMiB(long var1);
        }

        public static interface WithExtendedLocation {
            public WithSizeMiB withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithResourceGroup {
            public WithExtendedLocation withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithSizeMiB,
    DefinitionStages.WithCreate {
    }
}

