/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.MachineSkuProperties;
import com.azure.resourcemanager.networkcloud.models.BootstrapProtocol;
import com.azure.resourcemanager.networkcloud.models.MachineDisk;
import com.azure.resourcemanager.networkcloud.models.NetworkInterface;
import java.io.IOException;
import java.util.List;

public final class MachineSkuSlot
implements JsonSerializable<MachineSkuSlot> {
    private MachineSkuProperties innerProperties;
    private Long rackSlot;

    private MachineSkuProperties innerProperties() {
        return this.innerProperties;
    }

    public Long rackSlot() {
        return this.rackSlot;
    }

    public BootstrapProtocol bootstrapProtocol() {
        return this.innerProperties() == null ? null : this.innerProperties().bootstrapProtocol();
    }

    public Long cpuCores() {
        return this.innerProperties() == null ? null : this.innerProperties().cpuCores();
    }

    public Long cpuSockets() {
        return this.innerProperties() == null ? null : this.innerProperties().cpuSockets();
    }

    public List<MachineDisk> disks() {
        return this.innerProperties() == null ? null : this.innerProperties().disks();
    }

    public String generation() {
        return this.innerProperties() == null ? null : this.innerProperties().generation();
    }

    public String hardwareVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().hardwareVersion();
    }

    public Long memoryCapacityGB() {
        return this.innerProperties() == null ? null : this.innerProperties().memoryCapacityGB();
    }

    public String model() {
        return this.innerProperties() == null ? null : this.innerProperties().model();
    }

    public List<NetworkInterface> networkInterfaces() {
        return this.innerProperties() == null ? null : this.innerProperties().networkInterfaces();
    }

    public Long totalThreads() {
        return this.innerProperties() == null ? null : this.innerProperties().totalThreads();
    }

    public String vendor() {
        return this.innerProperties() == null ? null : this.innerProperties().vendor();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static MachineSkuSlot fromJson(JsonReader jsonReader) throws IOException {
        return (MachineSkuSlot)jsonReader.readObject(reader -> {
            MachineSkuSlot deserializedMachineSkuSlot = new MachineSkuSlot();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedMachineSkuSlot.innerProperties = MachineSkuProperties.fromJson(reader);
                    continue;
                }
                if ("rackSlot".equals(fieldName)) {
                    deserializedMachineSkuSlot.rackSlot = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMachineSkuSlot;
        });
    }
}

