/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AgentPoolMode;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterNodeDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.KubernetesLabel;
import com.azure.resourcemanager.networkcloud.models.KubernetesNodePowerState;
import com.azure.resourcemanager.networkcloud.models.KubernetesNodeRole;
import com.azure.resourcemanager.networkcloud.models.NetworkAttachment;
import java.io.IOException;
import java.util.List;

public final class KubernetesClusterNode
implements JsonSerializable<KubernetesClusterNode> {
    private String agentPoolId;
    private String availabilityZone;
    private String bareMetalMachineId;
    private Long cpuCores;
    private KubernetesClusterNodeDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private Long diskSizeGB;
    private String image;
    private String kubernetesVersion;
    private List<KubernetesLabel> labels;
    private Long memorySizeGB;
    private AgentPoolMode mode;
    private String name;
    private List<NetworkAttachment> networkAttachments;
    private KubernetesNodePowerState powerState;
    private KubernetesNodeRole role;
    private List<KubernetesLabel> taints;
    private String vmSkuName;

    public String agentPoolId() {
        return this.agentPoolId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String bareMetalMachineId() {
        return this.bareMetalMachineId;
    }

    public Long cpuCores() {
        return this.cpuCores;
    }

    public KubernetesClusterNodeDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public Long diskSizeGB() {
        return this.diskSizeGB;
    }

    public String image() {
        return this.image;
    }

    public String kubernetesVersion() {
        return this.kubernetesVersion;
    }

    public List<KubernetesLabel> labels() {
        return this.labels;
    }

    public Long memorySizeGB() {
        return this.memorySizeGB;
    }

    public AgentPoolMode mode() {
        return this.mode;
    }

    public String name() {
        return this.name;
    }

    public List<NetworkAttachment> networkAttachments() {
        return this.networkAttachments;
    }

    public KubernetesNodePowerState powerState() {
        return this.powerState;
    }

    public KubernetesNodeRole role() {
        return this.role;
    }

    public List<KubernetesLabel> taints() {
        return this.taints;
    }

    public String vmSkuName() {
        return this.vmSkuName;
    }

    public void validate() {
        if (this.labels() != null) {
            this.labels().forEach(e -> e.validate());
        }
        if (this.networkAttachments() != null) {
            this.networkAttachments().forEach(e -> e.validate());
        }
        if (this.taints() != null) {
            this.taints().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterNode fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterNode)jsonReader.readObject(reader -> {
            KubernetesClusterNode deserializedKubernetesClusterNode = new KubernetesClusterNode();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("agentPoolId".equals(fieldName)) {
                    deserializedKubernetesClusterNode.agentPoolId = reader.getString();
                    continue;
                }
                if ("availabilityZone".equals(fieldName)) {
                    deserializedKubernetesClusterNode.availabilityZone = reader.getString();
                    continue;
                }
                if ("bareMetalMachineId".equals(fieldName)) {
                    deserializedKubernetesClusterNode.bareMetalMachineId = reader.getString();
                    continue;
                }
                if ("cpuCores".equals(fieldName)) {
                    deserializedKubernetesClusterNode.cpuCores = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedKubernetesClusterNode.detailedStatus = KubernetesClusterNodeDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedKubernetesClusterNode.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedKubernetesClusterNode.diskSizeGB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("image".equals(fieldName)) {
                    deserializedKubernetesClusterNode.image = reader.getString();
                    continue;
                }
                if ("kubernetesVersion".equals(fieldName)) {
                    deserializedKubernetesClusterNode.kubernetesVersion = reader.getString();
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    List labels;
                    deserializedKubernetesClusterNode.labels = labels = reader.readArray(reader1 -> KubernetesLabel.fromJson(reader1));
                    continue;
                }
                if ("memorySizeGB".equals(fieldName)) {
                    deserializedKubernetesClusterNode.memorySizeGB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedKubernetesClusterNode.mode = AgentPoolMode.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedKubernetesClusterNode.name = reader.getString();
                    continue;
                }
                if ("networkAttachments".equals(fieldName)) {
                    List networkAttachments;
                    deserializedKubernetesClusterNode.networkAttachments = networkAttachments = reader.readArray(reader1 -> NetworkAttachment.fromJson(reader1));
                    continue;
                }
                if ("powerState".equals(fieldName)) {
                    deserializedKubernetesClusterNode.powerState = KubernetesNodePowerState.fromString(reader.getString());
                    continue;
                }
                if ("role".equals(fieldName)) {
                    deserializedKubernetesClusterNode.role = KubernetesNodeRole.fromString(reader.getString());
                    continue;
                }
                if ("taints".equals(fieldName)) {
                    List taints;
                    deserializedKubernetesClusterNode.taints = taints = reader.readArray(reader1 -> KubernetesLabel.fromJson(reader1));
                    continue;
                }
                if ("vmSkuName".equals(fieldName)) {
                    deserializedKubernetesClusterNode.vmSkuName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterNode;
        });
    }
}

