/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterInner;
import com.azure.resourcemanager.networkcloud.models.AadConfiguration;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfiguration;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfigurationPatch;
import com.azure.resourcemanager.networkcloud.models.AvailableUpgrade;
import com.azure.resourcemanager.networkcloud.models.ControlPlaneNodeConfiguration;
import com.azure.resourcemanager.networkcloud.models.ControlPlaneNodePatchConfiguration;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.FeatureStatus;
import com.azure.resourcemanager.networkcloud.models.InitialAgentPoolConfiguration;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterNode;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterProvisioningState;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterRestartNodeParameters;
import com.azure.resourcemanager.networkcloud.models.ManagedResourceGroupConfiguration;
import com.azure.resourcemanager.networkcloud.models.NetworkConfiguration;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import java.util.List;
import java.util.Map;

public interface KubernetesCluster {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public AadConfiguration aadConfiguration();

    public AdministratorConfiguration administratorConfiguration();

    public List<String> attachedNetworkIds();

    public List<AvailableUpgrade> availableUpgrades();

    public String clusterId();

    public String connectedClusterId();

    public String controlPlaneKubernetesVersion();

    public ControlPlaneNodeConfiguration controlPlaneNodeConfiguration();

    public KubernetesClusterDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public List<FeatureStatus> featureStatuses();

    public List<InitialAgentPoolConfiguration> initialAgentPoolConfigurations();

    public String kubernetesVersion();

    public ManagedResourceGroupConfiguration managedResourceGroupConfiguration();

    public NetworkConfiguration networkConfiguration();

    public List<KubernetesClusterNode> nodes();

    public KubernetesClusterProvisioningState provisioningState();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public KubernetesClusterInner innerModel();

    public Update update();

    public KubernetesCluster refresh();

    public KubernetesCluster refresh(Context var1);

    public OperationStatusResult restartNode(KubernetesClusterRestartNodeParameters var1);

    public OperationStatusResult restartNode(KubernetesClusterRestartNodeParameters var1, Context var2);

    public static interface UpdateStages {

        public static interface WithIfNoneMatch {
            public Update withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithKubernetesVersion {
            public Update withKubernetesVersion(String var1);
        }

        public static interface WithControlPlaneNodeConfiguration {
            public Update withControlPlaneNodeConfiguration(ControlPlaneNodePatchConfiguration var1);
        }

        public static interface WithAdministratorConfiguration {
            public Update withAdministratorConfiguration(AdministratorConfigurationPatch var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithAdministratorConfiguration,
    UpdateStages.WithControlPlaneNodeConfiguration,
    UpdateStages.WithKubernetesVersion,
    UpdateStages.WithIfMatch,
    UpdateStages.WithIfNoneMatch {
        public KubernetesCluster apply();

        public KubernetesCluster apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithManagedResourceGroupConfiguration {
            public WithCreate withManagedResourceGroupConfiguration(ManagedResourceGroupConfiguration var1);
        }

        public static interface WithAdministratorConfiguration {
            public WithCreate withAdministratorConfiguration(AdministratorConfiguration var1);
        }

        public static interface WithAadConfiguration {
            public WithCreate withAadConfiguration(AadConfiguration var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithAadConfiguration,
        WithAdministratorConfiguration,
        WithManagedResourceGroupConfiguration,
        WithIfMatch,
        WithIfNoneMatch {
            public KubernetesCluster create();

            public KubernetesCluster create(Context var1);
        }

        public static interface WithNetworkConfiguration {
            public WithCreate withNetworkConfiguration(NetworkConfiguration var1);
        }

        public static interface WithKubernetesVersion {
            public WithNetworkConfiguration withKubernetesVersion(String var1);
        }

        public static interface WithInitialAgentPoolConfigurations {
            public WithKubernetesVersion withInitialAgentPoolConfigurations(List<InitialAgentPoolConfiguration> var1);
        }

        public static interface WithControlPlaneNodeConfiguration {
            public WithInitialAgentPoolConfigurations withControlPlaneNodeConfiguration(ControlPlaneNodeConfiguration var1);
        }

        public static interface WithExtendedLocation {
            public WithControlPlaneNodeConfiguration withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithResourceGroup {
            public WithExtendedLocation withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithControlPlaneNodeConfiguration,
    DefinitionStages.WithInitialAgentPoolConfigurations,
    DefinitionStages.WithKubernetesVersion,
    DefinitionStages.WithNetworkConfiguration,
    DefinitionStages.WithCreate {
    }
}

