/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AdvertiseToFabric;
import java.io.IOException;
import java.util.List;

public final class BgpAdvertisement
implements JsonSerializable<BgpAdvertisement> {
    private AdvertiseToFabric advertiseToFabric;
    private List<String> communities;
    private List<String> ipAddressPools;
    private List<String> peers;
    private static final ClientLogger LOGGER = new ClientLogger(BgpAdvertisement.class);

    public AdvertiseToFabric advertiseToFabric() {
        return this.advertiseToFabric;
    }

    public BgpAdvertisement withAdvertiseToFabric(AdvertiseToFabric advertiseToFabric) {
        this.advertiseToFabric = advertiseToFabric;
        return this;
    }

    public List<String> communities() {
        return this.communities;
    }

    public BgpAdvertisement withCommunities(List<String> communities) {
        this.communities = communities;
        return this;
    }

    public List<String> ipAddressPools() {
        return this.ipAddressPools;
    }

    public BgpAdvertisement withIpAddressPools(List<String> ipAddressPools) {
        this.ipAddressPools = ipAddressPools;
        return this;
    }

    public List<String> peers() {
        return this.peers;
    }

    public BgpAdvertisement withPeers(List<String> peers) {
        this.peers = peers;
        return this;
    }

    public void validate() {
        if (this.ipAddressPools() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipAddressPools in model BgpAdvertisement"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipAddressPools", this.ipAddressPools, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("advertiseToFabric", this.advertiseToFabric == null ? null : this.advertiseToFabric.toString());
        jsonWriter.writeArrayField("communities", this.communities, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("peers", this.peers, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static BgpAdvertisement fromJson(JsonReader jsonReader) throws IOException {
        return (BgpAdvertisement)jsonReader.readObject(reader -> {
            BgpAdvertisement deserializedBgpAdvertisement = new BgpAdvertisement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipAddressPools".equals(fieldName)) {
                    List ipAddressPools;
                    deserializedBgpAdvertisement.ipAddressPools = ipAddressPools = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("advertiseToFabric".equals(fieldName)) {
                    deserializedBgpAdvertisement.advertiseToFabric = AdvertiseToFabric.fromString(reader.getString());
                    continue;
                }
                if ("communities".equals(fieldName)) {
                    List communities;
                    deserializedBgpAdvertisement.communities = communities = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("peers".equals(fieldName)) {
                    List peers;
                    deserializedBgpAdvertisement.peers = peers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBgpAdvertisement;
        });
    }
}

