/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.L2NetworkAttachmentConfiguration;
import com.azure.resourcemanager.networkcloud.models.L3NetworkAttachmentConfiguration;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworkAttachmentConfiguration;
import java.io.IOException;
import java.util.List;

public final class AttachedNetworkConfiguration
implements JsonSerializable<AttachedNetworkConfiguration> {
    private List<L2NetworkAttachmentConfiguration> l2Networks;
    private List<L3NetworkAttachmentConfiguration> l3Networks;
    private List<TrunkedNetworkAttachmentConfiguration> trunkedNetworks;

    public List<L2NetworkAttachmentConfiguration> l2Networks() {
        return this.l2Networks;
    }

    public AttachedNetworkConfiguration withL2Networks(List<L2NetworkAttachmentConfiguration> l2Networks) {
        this.l2Networks = l2Networks;
        return this;
    }

    public List<L3NetworkAttachmentConfiguration> l3Networks() {
        return this.l3Networks;
    }

    public AttachedNetworkConfiguration withL3Networks(List<L3NetworkAttachmentConfiguration> l3Networks) {
        this.l3Networks = l3Networks;
        return this;
    }

    public List<TrunkedNetworkAttachmentConfiguration> trunkedNetworks() {
        return this.trunkedNetworks;
    }

    public AttachedNetworkConfiguration withTrunkedNetworks(List<TrunkedNetworkAttachmentConfiguration> trunkedNetworks) {
        this.trunkedNetworks = trunkedNetworks;
        return this;
    }

    public void validate() {
        if (this.l2Networks() != null) {
            this.l2Networks().forEach(e -> e.validate());
        }
        if (this.l3Networks() != null) {
            this.l3Networks().forEach(e -> e.validate());
        }
        if (this.trunkedNetworks() != null) {
            this.trunkedNetworks().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("l2Networks", this.l2Networks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("l3Networks", this.l3Networks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("trunkedNetworks", this.trunkedNetworks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AttachedNetworkConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (AttachedNetworkConfiguration)jsonReader.readObject(reader -> {
            AttachedNetworkConfiguration deserializedAttachedNetworkConfiguration = new AttachedNetworkConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("l2Networks".equals(fieldName)) {
                    List l2Networks;
                    deserializedAttachedNetworkConfiguration.l2Networks = l2Networks = reader.readArray(reader1 -> L2NetworkAttachmentConfiguration.fromJson(reader1));
                    continue;
                }
                if ("l3Networks".equals(fieldName)) {
                    List l3Networks;
                    deserializedAttachedNetworkConfiguration.l3Networks = l3Networks = reader.readArray(reader1 -> L3NetworkAttachmentConfiguration.fromJson(reader1));
                    continue;
                }
                if ("trunkedNetworks".equals(fieldName)) {
                    List trunkedNetworks;
                    deserializedAttachedNetworkConfiguration.trunkedNetworks = trunkedNetworks = reader.readArray(reader1 -> TrunkedNetworkAttachmentConfiguration.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAttachedNetworkConfiguration;
        });
    }
}

