/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.VirtualMachinesClient;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.fluent.models.VirtualMachineInner;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.implementation.VirtualMachineImpl;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;
import com.azure.resourcemanager.networkcloud.models.VirtualMachine;
import com.azure.resourcemanager.networkcloud.models.VirtualMachineAssignRelayParameters;
import com.azure.resourcemanager.networkcloud.models.VirtualMachinePowerOffParameters;
import com.azure.resourcemanager.networkcloud.models.VirtualMachines;

public final class VirtualMachinesImpl
implements VirtualMachines {
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachinesImpl.class);
    private final VirtualMachinesClient innerClient;
    private final NetworkCloudManager serviceManager;

    public VirtualMachinesImpl(VirtualMachinesClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<VirtualMachine> list() {
        PagedIterable<VirtualMachineInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualMachineImpl((VirtualMachineInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VirtualMachine> list(Integer top, String skipToken, Context context) {
        PagedIterable<VirtualMachineInner> inner = this.serviceClient().list(top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualMachineImpl((VirtualMachineInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VirtualMachine> listByResourceGroup(String resourceGroupName) {
        PagedIterable<VirtualMachineInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualMachineImpl((VirtualMachineInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<VirtualMachine> listByResourceGroup(String resourceGroupName, Integer top, String skipToken, Context context) {
        PagedIterable<VirtualMachineInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VirtualMachineImpl((VirtualMachineInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<VirtualMachine> getByResourceGroupWithResponse(String resourceGroupName, String virtualMachineName, Context context) {
        Response<VirtualMachineInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, virtualMachineName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VirtualMachineImpl((VirtualMachineInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public VirtualMachine getByResourceGroup(String resourceGroupName, String virtualMachineName) {
        VirtualMachineInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, virtualMachineName);
        if (inner != null) {
            return new VirtualMachineImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String virtualMachineName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, virtualMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String virtualMachineName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, virtualMachineName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult assignRelay(String resourceGroupName, String virtualMachineName) {
        OperationStatusResultInner inner = this.serviceClient().assignRelay(resourceGroupName, virtualMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult assignRelay(String resourceGroupName, String virtualMachineName, VirtualMachineAssignRelayParameters virtualMachineAssignRelayParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().assignRelay(resourceGroupName, virtualMachineName, virtualMachineAssignRelayParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult powerOff(String resourceGroupName, String virtualMachineName) {
        OperationStatusResultInner inner = this.serviceClient().powerOff(resourceGroupName, virtualMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult powerOff(String resourceGroupName, String virtualMachineName, VirtualMachinePowerOffParameters virtualMachinePowerOffParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().powerOff(resourceGroupName, virtualMachineName, virtualMachinePowerOffParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult reimage(String resourceGroupName, String virtualMachineName) {
        OperationStatusResultInner inner = this.serviceClient().reimage(resourceGroupName, virtualMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult reimage(String resourceGroupName, String virtualMachineName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().reimage(resourceGroupName, virtualMachineName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult restart(String resourceGroupName, String virtualMachineName) {
        OperationStatusResultInner inner = this.serviceClient().restart(resourceGroupName, virtualMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult restart(String resourceGroupName, String virtualMachineName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().restart(resourceGroupName, virtualMachineName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String virtualMachineName) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, virtualMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String virtualMachineName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, virtualMachineName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public VirtualMachine getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (virtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        return (VirtualMachine)this.getByResourceGroupWithResponse(resourceGroupName, virtualMachineName, Context.NONE).getValue();
    }

    @Override
    public Response<VirtualMachine> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (virtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, virtualMachineName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (virtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, virtualMachineName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String virtualMachineName = ResourceManagerUtils.getValueFromIdByName(id, "virtualMachines");
        if (virtualMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'virtualMachines'.", id)));
        }
        return this.delete(resourceGroupName, virtualMachineName, ifMatch, ifNoneMatch, context);
    }

    private VirtualMachinesClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public VirtualMachineImpl define(String name) {
        return new VirtualMachineImpl(name, this.manager());
    }
}

