/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.networkcloud.fluent.MetricsConfigurationsClient;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterMetricsConfigurationInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudImpl;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfigurationList;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfigurationPatchParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class MetricsConfigurationsClientImpl
implements MetricsConfigurationsClient {
    private final MetricsConfigurationsService service;
    private final NetworkCloudImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(MetricsConfigurationsClientImpl.class);

    MetricsConfigurationsClientImpl(NetworkCloudImpl client) {
        this.service = (MetricsConfigurationsService)RestProxy.create(MetricsConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ClusterMetricsConfigurationInner>> listByClusterSinglePageAsync(String resourceGroupName, String clusterName, Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByCluster(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, top, skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterMetricsConfigurationList)res.getValue()).value(), ((ClusterMetricsConfigurationList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ClusterMetricsConfigurationInner> listByClusterAsync(String resourceGroupName, String clusterName, Integer top, String skipToken) {
        return new PagedFlux(() -> this.listByClusterSinglePageAsync(resourceGroupName, clusterName, top, skipToken), nextLink -> this.listByClusterNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ClusterMetricsConfigurationInner> listByClusterAsync(String resourceGroupName, String clusterName) {
        Integer top = null;
        String skipToken = null;
        return new PagedFlux(() -> this.listByClusterSinglePageAsync(resourceGroupName, clusterName, top, skipToken), nextLink -> this.listByClusterNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ClusterMetricsConfigurationInner> listByClusterSinglePage(String resourceGroupName, String clusterName, Integer top, String skipToken) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ClusterMetricsConfigurationList> res = this.service.listByClusterSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, top, skipToken, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterMetricsConfigurationList)res.getValue()).value(), ((ClusterMetricsConfigurationList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ClusterMetricsConfigurationInner> listByClusterSinglePage(String resourceGroupName, String clusterName, Integer top, String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ClusterMetricsConfigurationList> res = this.service.listByClusterSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, top, skipToken, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterMetricsConfigurationList)res.getValue()).value(), ((ClusterMetricsConfigurationList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ClusterMetricsConfigurationInner> listByCluster(String resourceGroupName, String clusterName) {
        Integer top = null;
        String skipToken = null;
        return new PagedIterable(() -> this.listByClusterSinglePage(resourceGroupName, clusterName, top, skipToken), nextLink -> this.listByClusterNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ClusterMetricsConfigurationInner> listByCluster(String resourceGroupName, String clusterName, Integer top, String skipToken, Context context) {
        return new PagedIterable(() -> this.listByClusterSinglePage(resourceGroupName, clusterName, top, skipToken, context), nextLink -> this.listByClusterNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ClusterMetricsConfigurationInner>> getWithResponseAsync(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (metricsConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metricsConfigurationName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, metricsConfigurationName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ClusterMetricsConfigurationInner> getAsync(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        return this.getWithResponseAsync(resourceGroupName, clusterName, metricsConfigurationName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ClusterMetricsConfigurationInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ClusterMetricsConfigurationInner> getWithResponse(String resourceGroupName, String clusterName, String metricsConfigurationName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (metricsConfigurationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter metricsConfigurationName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, metricsConfigurationName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterMetricsConfigurationInner get(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        return (ClusterMetricsConfigurationInner)((Object)this.getWithResponse(resourceGroupName, clusterName, metricsConfigurationName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (metricsConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metricsConfigurationName is required and cannot be null."));
        }
        if (metricsConfigurationParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metricsConfigurationParameters is required and cannot be null."));
        }
        metricsConfigurationParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (metricsConfigurationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter metricsConfigurationName is required and cannot be null."));
        }
        if (metricsConfigurationParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter metricsConfigurationParameters is required and cannot be null."));
        }
        metricsConfigurationParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (metricsConfigurationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter metricsConfigurationName is required and cannot be null."));
        }
        if (metricsConfigurationParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter metricsConfigurationParameters is required and cannot be null."));
        }
        metricsConfigurationParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ClusterMetricsConfigurationInner>, ClusterMetricsConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, clusterName, metricsConfigurationName, metricsConfigurationParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ClusterMetricsConfigurationInner.class), (Type)((Object)ClusterMetricsConfigurationInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ClusterMetricsConfigurationInner>, ClusterMetricsConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, clusterName, metricsConfigurationName, metricsConfigurationParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ClusterMetricsConfigurationInner.class), (Type)((Object)ClusterMetricsConfigurationInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterMetricsConfigurationInner>, ClusterMetricsConfigurationInner> beginCreateOrUpdate(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, clusterName, metricsConfigurationName, metricsConfigurationParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)ClusterMetricsConfigurationInner.class), (Type)((Object)ClusterMetricsConfigurationInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterMetricsConfigurationInner>, ClusterMetricsConfigurationInner> beginCreateOrUpdate(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, clusterName, metricsConfigurationName, metricsConfigurationParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)ClusterMetricsConfigurationInner.class), (Type)((Object)ClusterMetricsConfigurationInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterMetricsConfigurationInner>, ClusterMetricsConfigurationInner> beginCreateOrUpdate(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, clusterName, metricsConfigurationName, metricsConfigurationParameters, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)ClusterMetricsConfigurationInner.class), (Type)((Object)ClusterMetricsConfigurationInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ClusterMetricsConfigurationInner> createOrUpdateAsync(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, metricsConfigurationName, metricsConfigurationParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ClusterMetricsConfigurationInner> createOrUpdateAsync(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, metricsConfigurationName, metricsConfigurationParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterMetricsConfigurationInner createOrUpdate(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (ClusterMetricsConfigurationInner)((Object)this.beginCreateOrUpdate(resourceGroupName, clusterName, metricsConfigurationName, metricsConfigurationParameters, ifMatch, ifNoneMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterMetricsConfigurationInner createOrUpdate(String resourceGroupName, String clusterName, String metricsConfigurationName, ClusterMetricsConfigurationInner metricsConfigurationParameters, String ifMatch, String ifNoneMatch, Context context) {
        return (ClusterMetricsConfigurationInner)((Object)this.beginCreateOrUpdate(resourceGroupName, clusterName, metricsConfigurationName, metricsConfigurationParameters, ifMatch, ifNoneMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (metricsConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metricsConfigurationName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (metricsConfigurationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter metricsConfigurationName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (metricsConfigurationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter metricsConfigurationName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginDeleteAsync(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, Context context) {
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (metricsConfigurationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metricsConfigurationName is required and cannot be null."));
        }
        if (metricsConfigurationUpdateParameters != null) {
            metricsConfigurationUpdateParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (metricsConfigurationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter metricsConfigurationName is required and cannot be null."));
        }
        if (metricsConfigurationUpdateParameters != null) {
            metricsConfigurationUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (metricsConfigurationName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter metricsConfigurationName is required and cannot be null."));
        }
        if (metricsConfigurationUpdateParameters != null) {
            metricsConfigurationUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ClusterMetricsConfigurationInner>, ClusterMetricsConfigurationInner> beginUpdateAsync(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ClusterMetricsConfigurationInner.class), (Type)((Object)ClusterMetricsConfigurationInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ClusterMetricsConfigurationInner>, ClusterMetricsConfigurationInner> beginUpdateAsync(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ClusterMetricsConfigurationInner.class), (Type)((Object)ClusterMetricsConfigurationInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterMetricsConfigurationInner>, ClusterMetricsConfigurationInner> beginUpdate(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)ClusterMetricsConfigurationInner.class), (Type)((Object)ClusterMetricsConfigurationInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterMetricsConfigurationInner>, ClusterMetricsConfigurationInner> beginUpdate(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters = null;
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)ClusterMetricsConfigurationInner.class), (Type)((Object)ClusterMetricsConfigurationInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterMetricsConfigurationInner>, ClusterMetricsConfigurationInner> beginUpdate(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters, context);
        return this.client.getLroResult(response, (Type)((Object)ClusterMetricsConfigurationInner.class), (Type)((Object)ClusterMetricsConfigurationInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ClusterMetricsConfigurationInner> updateAsync(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ClusterMetricsConfigurationInner> updateAsync(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterMetricsConfigurationInner update(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters = null;
        return (ClusterMetricsConfigurationInner)((Object)this.beginUpdate(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterMetricsConfigurationInner update(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, ClusterMetricsConfigurationPatchParameters metricsConfigurationUpdateParameters, Context context) {
        return (ClusterMetricsConfigurationInner)((Object)this.beginUpdate(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, metricsConfigurationUpdateParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ClusterMetricsConfigurationInner>> listByClusterNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByClusterNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterMetricsConfigurationList)res.getValue()).value(), ((ClusterMetricsConfigurationList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ClusterMetricsConfigurationInner> listByClusterNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ClusterMetricsConfigurationList> res = this.service.listByClusterNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterMetricsConfigurationList)res.getValue()).value(), ((ClusterMetricsConfigurationList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ClusterMetricsConfigurationInner> listByClusterNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ClusterMetricsConfigurationList> res = this.service.listByClusterNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ClusterMetricsConfigurationList)res.getValue()).value(), ((ClusterMetricsConfigurationList)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkCloudMetricsConfigurations")
    public static interface MetricsConfigurationsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ClusterMetricsConfigurationList>> listByCluster(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$skipToken") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ClusterMetricsConfigurationList> listByClusterSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$skipToken") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations/{metricsConfigurationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ClusterMetricsConfigurationInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="metricsConfigurationName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations/{metricsConfigurationName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ClusterMetricsConfigurationInner> getSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="metricsConfigurationName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations/{metricsConfigurationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="metricsConfigurationName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") ClusterMetricsConfigurationInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations/{metricsConfigurationName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="metricsConfigurationName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") ClusterMetricsConfigurationInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations/{metricsConfigurationName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="metricsConfigurationName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations/{metricsConfigurationName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="metricsConfigurationName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations/{metricsConfigurationName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="metricsConfigurationName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") ClusterMetricsConfigurationPatchParameters var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/metricsConfigurations/{metricsConfigurationName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="metricsConfigurationName") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, @BodyParam(value="application/json") ClusterMetricsConfigurationPatchParameters var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ClusterMetricsConfigurationList>> listByClusterNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ClusterMetricsConfigurationList> listByClusterNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

