/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.BmcKeySetsClient;
import com.azure.resourcemanager.networkcloud.fluent.models.BmcKeySetInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.BmcKeySetImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.BmcKeySet;
import com.azure.resourcemanager.networkcloud.models.BmcKeySets;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class BmcKeySetsImpl
implements BmcKeySets {
    private static final ClientLogger LOGGER = new ClientLogger(BmcKeySetsImpl.class);
    private final BmcKeySetsClient innerClient;
    private final NetworkCloudManager serviceManager;

    public BmcKeySetsImpl(BmcKeySetsClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<BmcKeySet> listByCluster(String resourceGroupName, String clusterName) {
        PagedIterable<BmcKeySetInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BmcKeySetImpl((BmcKeySetInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BmcKeySet> listByCluster(String resourceGroupName, String clusterName, Integer top, String skipToken, Context context) {
        PagedIterable<BmcKeySetInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName, top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BmcKeySetImpl((BmcKeySetInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<BmcKeySet> getWithResponse(String resourceGroupName, String clusterName, String bmcKeySetName, Context context) {
        Response<BmcKeySetInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, bmcKeySetName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BmcKeySetImpl((BmcKeySetInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BmcKeySet get(String resourceGroupName, String clusterName, String bmcKeySetName) {
        BmcKeySetInner inner = this.serviceClient().get(resourceGroupName, clusterName, bmcKeySetName);
        if (inner != null) {
            return new BmcKeySetImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String clusterName, String bmcKeySetName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, clusterName, bmcKeySetName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String clusterName, String bmcKeySetName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, clusterName, bmcKeySetName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BmcKeySet getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String bmcKeySetName = ResourceManagerUtils.getValueFromIdByName(id, "bmcKeySets");
        if (bmcKeySetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bmcKeySets'.", id)));
        }
        return (BmcKeySet)this.getWithResponse(resourceGroupName, clusterName, bmcKeySetName, Context.NONE).getValue();
    }

    @Override
    public Response<BmcKeySet> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String bmcKeySetName = ResourceManagerUtils.getValueFromIdByName(id, "bmcKeySets");
        if (bmcKeySetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bmcKeySets'.", id)));
        }
        return this.getWithResponse(resourceGroupName, clusterName, bmcKeySetName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String bmcKeySetName = ResourceManagerUtils.getValueFromIdByName(id, "bmcKeySets");
        if (bmcKeySetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bmcKeySets'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, clusterName, bmcKeySetName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String bmcKeySetName = ResourceManagerUtils.getValueFromIdByName(id, "bmcKeySets");
        if (bmcKeySetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bmcKeySets'.", id)));
        }
        return this.delete(resourceGroupName, clusterName, bmcKeySetName, ifMatch, ifNoneMatch, context);
    }

    private BmcKeySetsClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public BmcKeySetImpl define(String name) {
        return new BmcKeySetImpl(name, this.manager());
    }
}

