/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.BareMetalMachinesClient;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.BareMetalMachineImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachine;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineCordonParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachinePowerOffParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineReplaceParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunCommandParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunDataExtractsParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineRunReadCommandsParameters;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachines;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class BareMetalMachinesImpl
implements BareMetalMachines {
    private static final ClientLogger LOGGER = new ClientLogger(BareMetalMachinesImpl.class);
    private final BareMetalMachinesClient innerClient;
    private final NetworkCloudManager serviceManager;

    public BareMetalMachinesImpl(BareMetalMachinesClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<BareMetalMachine> list() {
        PagedIterable<BareMetalMachineInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BareMetalMachineImpl((BareMetalMachineInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BareMetalMachine> list(Integer top, String skipToken, Context context) {
        PagedIterable<BareMetalMachineInner> inner = this.serviceClient().list(top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BareMetalMachineImpl((BareMetalMachineInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BareMetalMachine> listByResourceGroup(String resourceGroupName) {
        PagedIterable<BareMetalMachineInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BareMetalMachineImpl((BareMetalMachineInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<BareMetalMachine> listByResourceGroup(String resourceGroupName, Integer top, String skipToken, Context context) {
        PagedIterable<BareMetalMachineInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, top, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new BareMetalMachineImpl((BareMetalMachineInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<BareMetalMachine> getByResourceGroupWithResponse(String resourceGroupName, String bareMetalMachineName, Context context) {
        Response<BareMetalMachineInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, bareMetalMachineName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BareMetalMachineImpl((BareMetalMachineInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public BareMetalMachine getByResourceGroup(String resourceGroupName, String bareMetalMachineName) {
        BareMetalMachineInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, bareMetalMachineName);
        if (inner != null) {
            return new BareMetalMachineImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String bareMetalMachineName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, bareMetalMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String bareMetalMachineName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult cordon(String resourceGroupName, String bareMetalMachineName) {
        OperationStatusResultInner inner = this.serviceClient().cordon(resourceGroupName, bareMetalMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult cordon(String resourceGroupName, String bareMetalMachineName, BareMetalMachineCordonParameters bareMetalMachineCordonParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().cordon(resourceGroupName, bareMetalMachineName, bareMetalMachineCordonParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult powerOff(String resourceGroupName, String bareMetalMachineName) {
        OperationStatusResultInner inner = this.serviceClient().powerOff(resourceGroupName, bareMetalMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult powerOff(String resourceGroupName, String bareMetalMachineName, BareMetalMachinePowerOffParameters bareMetalMachinePowerOffParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().powerOff(resourceGroupName, bareMetalMachineName, bareMetalMachinePowerOffParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult reimage(String resourceGroupName, String bareMetalMachineName) {
        OperationStatusResultInner inner = this.serviceClient().reimage(resourceGroupName, bareMetalMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult reimage(String resourceGroupName, String bareMetalMachineName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().reimage(resourceGroupName, bareMetalMachineName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult replace(String resourceGroupName, String bareMetalMachineName) {
        OperationStatusResultInner inner = this.serviceClient().replace(resourceGroupName, bareMetalMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult replace(String resourceGroupName, String bareMetalMachineName, BareMetalMachineReplaceParameters bareMetalMachineReplaceParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().replace(resourceGroupName, bareMetalMachineName, bareMetalMachineReplaceParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult restart(String resourceGroupName, String bareMetalMachineName) {
        OperationStatusResultInner inner = this.serviceClient().restart(resourceGroupName, bareMetalMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult restart(String resourceGroupName, String bareMetalMachineName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().restart(resourceGroupName, bareMetalMachineName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult runCommand(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters) {
        OperationStatusResultInner inner = this.serviceClient().runCommand(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult runCommand(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunCommandParameters bareMetalMachineRunCommandParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().runCommand(resourceGroupName, bareMetalMachineName, bareMetalMachineRunCommandParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult runDataExtracts(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters) {
        OperationStatusResultInner inner = this.serviceClient().runDataExtracts(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult runDataExtracts(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().runDataExtracts(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult runDataExtractsRestricted(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsRestrictedParameters) {
        OperationStatusResultInner inner = this.serviceClient().runDataExtractsRestricted(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsRestrictedParameters);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult runDataExtractsRestricted(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunDataExtractsParameters bareMetalMachineRunDataExtractsRestrictedParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().runDataExtractsRestricted(resourceGroupName, bareMetalMachineName, bareMetalMachineRunDataExtractsRestrictedParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult runReadCommands(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters) {
        OperationStatusResultInner inner = this.serviceClient().runReadCommands(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult runReadCommands(String resourceGroupName, String bareMetalMachineName, BareMetalMachineRunReadCommandsParameters bareMetalMachineRunReadCommandsParameters, Context context) {
        OperationStatusResultInner inner = this.serviceClient().runReadCommands(resourceGroupName, bareMetalMachineName, bareMetalMachineRunReadCommandsParameters, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String bareMetalMachineName) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, bareMetalMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult start(String resourceGroupName, String bareMetalMachineName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().start(resourceGroupName, bareMetalMachineName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult uncordon(String resourceGroupName, String bareMetalMachineName) {
        OperationStatusResultInner inner = this.serviceClient().uncordon(resourceGroupName, bareMetalMachineName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult uncordon(String resourceGroupName, String bareMetalMachineName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().uncordon(resourceGroupName, bareMetalMachineName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public BareMetalMachine getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String bareMetalMachineName = ResourceManagerUtils.getValueFromIdByName(id, "bareMetalMachines");
        if (bareMetalMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bareMetalMachines'.", id)));
        }
        return (BareMetalMachine)this.getByResourceGroupWithResponse(resourceGroupName, bareMetalMachineName, Context.NONE).getValue();
    }

    @Override
    public Response<BareMetalMachine> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String bareMetalMachineName = ResourceManagerUtils.getValueFromIdByName(id, "bareMetalMachines");
        if (bareMetalMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bareMetalMachines'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, bareMetalMachineName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String bareMetalMachineName = ResourceManagerUtils.getValueFromIdByName(id, "bareMetalMachines");
        if (bareMetalMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bareMetalMachines'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, bareMetalMachineName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String bareMetalMachineName = ResourceManagerUtils.getValueFromIdByName(id, "bareMetalMachines");
        if (bareMetalMachineName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'bareMetalMachines'.", id)));
        }
        return this.delete(resourceGroupName, bareMetalMachineName, ifMatch, ifNoneMatch, context);
    }

    private BareMetalMachinesClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public BareMetalMachineImpl define(String name) {
        return new BareMetalMachineImpl(name, this.manager());
    }
}

