/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.L2NetworkProperties;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.L2NetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.L2NetworkProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class L2NetworkInner
extends Resource {
    private String etag;
    private ExtendedLocation extendedLocation;
    private L2NetworkProperties innerProperties = new L2NetworkProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(L2NetworkInner.class);

    public String etag() {
        return this.etag;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public L2NetworkInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private L2NetworkProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public L2NetworkInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public L2NetworkInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<String> associatedResourceIds() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedResourceIds();
    }

    public String clusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterId();
    }

    public L2NetworkDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public List<String> hybridAksClustersAssociatedIds() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridAksClustersAssociatedIds();
    }

    public HybridAksPluginType hybridAksPluginType() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridAksPluginType();
    }

    public L2NetworkInner withHybridAksPluginType(HybridAksPluginType hybridAksPluginType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new L2NetworkProperties();
        }
        this.innerProperties().withHybridAksPluginType(hybridAksPluginType);
        return this;
    }

    public String interfaceName() {
        return this.innerProperties() == null ? null : this.innerProperties().interfaceName();
    }

    public L2NetworkInner withInterfaceName(String interfaceName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new L2NetworkProperties();
        }
        this.innerProperties().withInterfaceName(interfaceName);
        return this;
    }

    public String l2IsolationDomainId() {
        return this.innerProperties() == null ? null : this.innerProperties().l2IsolationDomainId();
    }

    public L2NetworkInner withL2IsolationDomainId(String l2IsolationDomainId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new L2NetworkProperties();
        }
        this.innerProperties().withL2IsolationDomainId(l2IsolationDomainId);
        return this;
    }

    public L2NetworkProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<String> virtualMachinesAssociatedIds() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachinesAssociatedIds();
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model L2NetworkInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model L2NetworkInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static L2NetworkInner fromJson(JsonReader jsonReader) throws IOException {
        return (L2NetworkInner)((Object)jsonReader.readObject(reader -> {
            L2NetworkInner deserializedL2NetworkInner = new L2NetworkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedL2NetworkInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedL2NetworkInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedL2NetworkInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedL2NetworkInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedL2NetworkInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedL2NetworkInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedL2NetworkInner.innerProperties = L2NetworkProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedL2NetworkInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedL2NetworkInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedL2NetworkInner;
        }));
    }
}

