/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkEnableDefaultEgressEndpoints;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkProvisioningState;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkStorageOptions;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkStorageStatus;
import com.azure.resourcemanager.networkcloud.models.EgressEndpoint;
import java.io.IOException;
import java.util.List;

public final class CloudServicesNetworkProperties
implements JsonSerializable<CloudServicesNetworkProperties> {
    private List<EgressEndpoint> additionalEgressEndpoints;
    private List<String> associatedResourceIds;
    private String clusterId;
    private CloudServicesNetworkDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints;
    private List<EgressEndpoint> enabledEgressEndpoints;
    private List<String> hybridAksClustersAssociatedIds;
    private String interfaceName;
    private CloudServicesNetworkProvisioningState provisioningState;
    private CloudServicesNetworkStorageOptions storageOptions;
    private CloudServicesNetworkStorageStatus storageStatus;
    private List<String> virtualMachinesAssociatedIds;

    public List<EgressEndpoint> additionalEgressEndpoints() {
        return this.additionalEgressEndpoints;
    }

    public CloudServicesNetworkProperties withAdditionalEgressEndpoints(List<EgressEndpoint> additionalEgressEndpoints) {
        this.additionalEgressEndpoints = additionalEgressEndpoints;
        return this;
    }

    public List<String> associatedResourceIds() {
        return this.associatedResourceIds;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public CloudServicesNetworkDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints() {
        return this.enableDefaultEgressEndpoints;
    }

    public CloudServicesNetworkProperties withEnableDefaultEgressEndpoints(CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints) {
        this.enableDefaultEgressEndpoints = enableDefaultEgressEndpoints;
        return this;
    }

    public List<EgressEndpoint> enabledEgressEndpoints() {
        return this.enabledEgressEndpoints;
    }

    public List<String> hybridAksClustersAssociatedIds() {
        return this.hybridAksClustersAssociatedIds;
    }

    public String interfaceName() {
        return this.interfaceName;
    }

    public CloudServicesNetworkProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public CloudServicesNetworkStorageOptions storageOptions() {
        return this.storageOptions;
    }

    public CloudServicesNetworkProperties withStorageOptions(CloudServicesNetworkStorageOptions storageOptions) {
        this.storageOptions = storageOptions;
        return this;
    }

    public CloudServicesNetworkStorageStatus storageStatus() {
        return this.storageStatus;
    }

    public List<String> virtualMachinesAssociatedIds() {
        return this.virtualMachinesAssociatedIds;
    }

    public void validate() {
        if (this.additionalEgressEndpoints() != null) {
            this.additionalEgressEndpoints().forEach(e -> e.validate());
        }
        if (this.enabledEgressEndpoints() != null) {
            this.enabledEgressEndpoints().forEach(e -> e.validate());
        }
        if (this.storageOptions() != null) {
            this.storageOptions().validate();
        }
        if (this.storageStatus() != null) {
            this.storageStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("additionalEgressEndpoints", this.additionalEgressEndpoints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("enableDefaultEgressEndpoints", this.enableDefaultEgressEndpoints == null ? null : this.enableDefaultEgressEndpoints.toString());
        jsonWriter.writeJsonField("storageOptions", (JsonSerializable)this.storageOptions);
        return jsonWriter.writeEndObject();
    }

    public static CloudServicesNetworkProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServicesNetworkProperties)jsonReader.readObject(reader -> {
            CloudServicesNetworkProperties deserializedCloudServicesNetworkProperties = new CloudServicesNetworkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("additionalEgressEndpoints".equals(fieldName)) {
                    List additionalEgressEndpoints;
                    deserializedCloudServicesNetworkProperties.additionalEgressEndpoints = additionalEgressEndpoints = reader.readArray(reader1 -> EgressEndpoint.fromJson(reader1));
                    continue;
                }
                if ("associatedResourceIds".equals(fieldName)) {
                    List associatedResourceIds;
                    deserializedCloudServicesNetworkProperties.associatedResourceIds = associatedResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedCloudServicesNetworkProperties.clusterId = reader.getString();
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedCloudServicesNetworkProperties.detailedStatus = CloudServicesNetworkDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedCloudServicesNetworkProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("enableDefaultEgressEndpoints".equals(fieldName)) {
                    deserializedCloudServicesNetworkProperties.enableDefaultEgressEndpoints = CloudServicesNetworkEnableDefaultEgressEndpoints.fromString(reader.getString());
                    continue;
                }
                if ("enabledEgressEndpoints".equals(fieldName)) {
                    List enabledEgressEndpoints;
                    deserializedCloudServicesNetworkProperties.enabledEgressEndpoints = enabledEgressEndpoints = reader.readArray(reader1 -> EgressEndpoint.fromJson(reader1));
                    continue;
                }
                if ("hybridAksClustersAssociatedIds".equals(fieldName)) {
                    List hybridAksClustersAssociatedIds;
                    deserializedCloudServicesNetworkProperties.hybridAksClustersAssociatedIds = hybridAksClustersAssociatedIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("interfaceName".equals(fieldName)) {
                    deserializedCloudServicesNetworkProperties.interfaceName = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCloudServicesNetworkProperties.provisioningState = CloudServicesNetworkProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("storageOptions".equals(fieldName)) {
                    deserializedCloudServicesNetworkProperties.storageOptions = CloudServicesNetworkStorageOptions.fromJson(reader);
                    continue;
                }
                if ("storageStatus".equals(fieldName)) {
                    deserializedCloudServicesNetworkProperties.storageStatus = CloudServicesNetworkStorageStatus.fromJson(reader);
                    continue;
                }
                if ("virtualMachinesAssociatedIds".equals(fieldName)) {
                    List virtualMachinesAssociatedIds;
                    deserializedCloudServicesNetworkProperties.virtualMachinesAssociatedIds = virtualMachinesAssociatedIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServicesNetworkProperties;
        });
    }
}

