/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.fluent.NetworkCloud;
import com.azure.resourcemanager.networkcloud.implementation.AgentPoolsImpl;
import com.azure.resourcemanager.networkcloud.implementation.BareMetalMachineKeySetsImpl;
import com.azure.resourcemanager.networkcloud.implementation.BareMetalMachinesImpl;
import com.azure.resourcemanager.networkcloud.implementation.BmcKeySetsImpl;
import com.azure.resourcemanager.networkcloud.implementation.CloudServicesNetworksImpl;
import com.azure.resourcemanager.networkcloud.implementation.ClusterManagersImpl;
import com.azure.resourcemanager.networkcloud.implementation.ClustersImpl;
import com.azure.resourcemanager.networkcloud.implementation.ConsolesImpl;
import com.azure.resourcemanager.networkcloud.implementation.KubernetesClusterFeaturesImpl;
import com.azure.resourcemanager.networkcloud.implementation.KubernetesClustersImpl;
import com.azure.resourcemanager.networkcloud.implementation.L2NetworksImpl;
import com.azure.resourcemanager.networkcloud.implementation.L3NetworksImpl;
import com.azure.resourcemanager.networkcloud.implementation.MetricsConfigurationsImpl;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudBuilder;
import com.azure.resourcemanager.networkcloud.implementation.OperationsImpl;
import com.azure.resourcemanager.networkcloud.implementation.RackSkusImpl;
import com.azure.resourcemanager.networkcloud.implementation.RacksImpl;
import com.azure.resourcemanager.networkcloud.implementation.StorageAppliancesImpl;
import com.azure.resourcemanager.networkcloud.implementation.TrunkedNetworksImpl;
import com.azure.resourcemanager.networkcloud.implementation.VirtualMachinesImpl;
import com.azure.resourcemanager.networkcloud.implementation.VolumesImpl;
import com.azure.resourcemanager.networkcloud.models.AgentPools;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySets;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachines;
import com.azure.resourcemanager.networkcloud.models.BmcKeySets;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworks;
import com.azure.resourcemanager.networkcloud.models.ClusterManagers;
import com.azure.resourcemanager.networkcloud.models.Clusters;
import com.azure.resourcemanager.networkcloud.models.Consoles;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatures;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusters;
import com.azure.resourcemanager.networkcloud.models.L2Networks;
import com.azure.resourcemanager.networkcloud.models.L3Networks;
import com.azure.resourcemanager.networkcloud.models.MetricsConfigurations;
import com.azure.resourcemanager.networkcloud.models.Operations;
import com.azure.resourcemanager.networkcloud.models.RackSkus;
import com.azure.resourcemanager.networkcloud.models.Racks;
import com.azure.resourcemanager.networkcloud.models.StorageAppliances;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworks;
import com.azure.resourcemanager.networkcloud.models.VirtualMachines;
import com.azure.resourcemanager.networkcloud.models.Volumes;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class NetworkCloudManager {
    private Operations operations;
    private BareMetalMachines bareMetalMachines;
    private CloudServicesNetworks cloudServicesNetworks;
    private ClusterManagers clusterManagers;
    private Clusters clusters;
    private KubernetesClusters kubernetesClusters;
    private L2Networks l2Networks;
    private L3Networks l3Networks;
    private RackSkus rackSkus;
    private Racks racks;
    private StorageAppliances storageAppliances;
    private TrunkedNetworks trunkedNetworks;
    private VirtualMachines virtualMachines;
    private Volumes volumes;
    private BareMetalMachineKeySets bareMetalMachineKeySets;
    private BmcKeySets bmcKeySets;
    private MetricsConfigurations metricsConfigurations;
    private AgentPools agentPools;
    private KubernetesClusterFeatures kubernetesClusterFeatures;
    private Consoles consoles;
    private final NetworkCloud clientObject;

    private NetworkCloudManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new NetworkCloudBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static NetworkCloudManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return NetworkCloudManager.configure().authenticate(credential, profile);
    }

    public static NetworkCloudManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new NetworkCloudManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public BareMetalMachines bareMetalMachines() {
        if (this.bareMetalMachines == null) {
            this.bareMetalMachines = new BareMetalMachinesImpl(this.clientObject.getBareMetalMachines(), this);
        }
        return this.bareMetalMachines;
    }

    public CloudServicesNetworks cloudServicesNetworks() {
        if (this.cloudServicesNetworks == null) {
            this.cloudServicesNetworks = new CloudServicesNetworksImpl(this.clientObject.getCloudServicesNetworks(), this);
        }
        return this.cloudServicesNetworks;
    }

    public ClusterManagers clusterManagers() {
        if (this.clusterManagers == null) {
            this.clusterManagers = new ClusterManagersImpl(this.clientObject.getClusterManagers(), this);
        }
        return this.clusterManagers;
    }

    public Clusters clusters() {
        if (this.clusters == null) {
            this.clusters = new ClustersImpl(this.clientObject.getClusters(), this);
        }
        return this.clusters;
    }

    public KubernetesClusters kubernetesClusters() {
        if (this.kubernetesClusters == null) {
            this.kubernetesClusters = new KubernetesClustersImpl(this.clientObject.getKubernetesClusters(), this);
        }
        return this.kubernetesClusters;
    }

    public L2Networks l2Networks() {
        if (this.l2Networks == null) {
            this.l2Networks = new L2NetworksImpl(this.clientObject.getL2Networks(), this);
        }
        return this.l2Networks;
    }

    public L3Networks l3Networks() {
        if (this.l3Networks == null) {
            this.l3Networks = new L3NetworksImpl(this.clientObject.getL3Networks(), this);
        }
        return this.l3Networks;
    }

    public RackSkus rackSkus() {
        if (this.rackSkus == null) {
            this.rackSkus = new RackSkusImpl(this.clientObject.getRackSkus(), this);
        }
        return this.rackSkus;
    }

    public Racks racks() {
        if (this.racks == null) {
            this.racks = new RacksImpl(this.clientObject.getRacks(), this);
        }
        return this.racks;
    }

    public StorageAppliances storageAppliances() {
        if (this.storageAppliances == null) {
            this.storageAppliances = new StorageAppliancesImpl(this.clientObject.getStorageAppliances(), this);
        }
        return this.storageAppliances;
    }

    public TrunkedNetworks trunkedNetworks() {
        if (this.trunkedNetworks == null) {
            this.trunkedNetworks = new TrunkedNetworksImpl(this.clientObject.getTrunkedNetworks(), this);
        }
        return this.trunkedNetworks;
    }

    public VirtualMachines virtualMachines() {
        if (this.virtualMachines == null) {
            this.virtualMachines = new VirtualMachinesImpl(this.clientObject.getVirtualMachines(), this);
        }
        return this.virtualMachines;
    }

    public Volumes volumes() {
        if (this.volumes == null) {
            this.volumes = new VolumesImpl(this.clientObject.getVolumes(), this);
        }
        return this.volumes;
    }

    public BareMetalMachineKeySets bareMetalMachineKeySets() {
        if (this.bareMetalMachineKeySets == null) {
            this.bareMetalMachineKeySets = new BareMetalMachineKeySetsImpl(this.clientObject.getBareMetalMachineKeySets(), this);
        }
        return this.bareMetalMachineKeySets;
    }

    public BmcKeySets bmcKeySets() {
        if (this.bmcKeySets == null) {
            this.bmcKeySets = new BmcKeySetsImpl(this.clientObject.getBmcKeySets(), this);
        }
        return this.bmcKeySets;
    }

    public MetricsConfigurations metricsConfigurations() {
        if (this.metricsConfigurations == null) {
            this.metricsConfigurations = new MetricsConfigurationsImpl(this.clientObject.getMetricsConfigurations(), this);
        }
        return this.metricsConfigurations;
    }

    public AgentPools agentPools() {
        if (this.agentPools == null) {
            this.agentPools = new AgentPoolsImpl(this.clientObject.getAgentPools(), this);
        }
        return this.agentPools;
    }

    public KubernetesClusterFeatures kubernetesClusterFeatures() {
        if (this.kubernetesClusterFeatures == null) {
            this.kubernetesClusterFeatures = new KubernetesClusterFeaturesImpl(this.clientObject.getKubernetesClusterFeatures(), this);
        }
        return this.kubernetesClusterFeatures;
    }

    public Consoles consoles() {
        if (this.consoles == null) {
            this.consoles = new ConsolesImpl(this.clientObject.getConsoles(), this);
        }
        return this.consoles;
    }

    public NetworkCloud serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-networkcloud.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public NetworkCloudManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.networkcloud").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new NetworkCloudManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

