/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.TrunkedNetworkInner;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworkProvisioningState;
import java.util.List;
import java.util.Map;

public interface TrunkedNetwork {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public List<String> associatedResourceIds();

    public String clusterId();

    public TrunkedNetworkDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public List<String> hybridAksClustersAssociatedIds();

    public HybridAksPluginType hybridAksPluginType();

    public String interfaceName();

    public List<String> isolationDomainIds();

    public TrunkedNetworkProvisioningState provisioningState();

    public List<String> virtualMachinesAssociatedIds();

    public List<Long> vlans();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public TrunkedNetworkInner innerModel();

    public Update update();

    public TrunkedNetwork refresh();

    public TrunkedNetwork refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public TrunkedNetwork apply();

        public TrunkedNetwork apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithInterfaceName {
            public WithCreate withInterfaceName(String var1);
        }

        public static interface WithHybridAksPluginType {
            public WithCreate withHybridAksPluginType(HybridAksPluginType var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithHybridAksPluginType,
        WithInterfaceName {
            public TrunkedNetwork create();

            public TrunkedNetwork create(Context var1);
        }

        public static interface WithVlans {
            public WithCreate withVlans(List<Long> var1);
        }

        public static interface WithIsolationDomainIds {
            public WithVlans withIsolationDomainIds(List<String> var1);
        }

        public static interface WithExtendedLocation {
            public WithIsolationDomainIds withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithResourceGroup {
            public WithExtendedLocation withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithIsolationDomainIds,
    DefinitionStages.WithVlans,
    DefinitionStages.WithCreate {
    }
}

