/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterInner;
import java.io.IOException;
import java.util.List;

public final class KubernetesClusterList
implements JsonSerializable<KubernetesClusterList> {
    private String nextLink;
    private List<KubernetesClusterInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public KubernetesClusterList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<KubernetesClusterInner> value() {
        return this.value;
    }

    public KubernetesClusterList withValue(List<KubernetesClusterInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterList fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterList)jsonReader.readObject(reader -> {
            KubernetesClusterList deserializedKubernetesClusterList = new KubernetesClusterList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedKubernetesClusterList.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedKubernetesClusterList.value = value = reader.readArray(reader1 -> KubernetesClusterInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterList;
        });
    }
}

