/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EndpointDependency
implements JsonSerializable<EndpointDependency> {
    private String domainName;
    private Long port;
    private static final ClientLogger LOGGER = new ClientLogger(EndpointDependency.class);

    public String domainName() {
        return this.domainName;
    }

    public EndpointDependency withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public Long port() {
        return this.port;
    }

    public EndpointDependency withPort(Long port) {
        this.port = port;
        return this;
    }

    public void validate() {
        if (this.domainName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property domainName in model EndpointDependency"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("domainName", this.domainName);
        jsonWriter.writeNumberField("port", (Number)this.port);
        return jsonWriter.writeEndObject();
    }

    public static EndpointDependency fromJson(JsonReader jsonReader) throws IOException {
        return (EndpointDependency)jsonReader.readObject(reader -> {
            EndpointDependency deserializedEndpointDependency = new EndpointDependency();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("domainName".equals(fieldName)) {
                    deserializedEndpointDependency.domainName = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedEndpointDependency.port = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpointDependency;
        });
    }
}

