/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.AgentPoolInner;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfiguration;
import com.azure.resourcemanager.networkcloud.models.AgentOptions;
import com.azure.resourcemanager.networkcloud.models.AgentPoolDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.AgentPoolMode;
import com.azure.resourcemanager.networkcloud.models.AgentPoolProvisioningState;
import com.azure.resourcemanager.networkcloud.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.networkcloud.models.AttachedNetworkConfiguration;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.KubernetesLabel;
import com.azure.resourcemanager.networkcloud.models.NodePoolAdministratorConfigurationPatch;
import java.util.List;
import java.util.Map;

public interface AgentPool {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public AdministratorConfiguration administratorConfiguration();

    public AgentOptions agentOptions();

    public AttachedNetworkConfiguration attachedNetworkConfiguration();

    public List<String> availabilityZones();

    public long count();

    public AgentPoolDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public String kubernetesVersion();

    public List<KubernetesLabel> labels();

    public AgentPoolMode mode();

    public AgentPoolProvisioningState provisioningState();

    public List<KubernetesLabel> taints();

    public AgentPoolUpgradeSettings upgradeSettings();

    public String vmSkuName();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public AgentPoolInner innerModel();

    public Update update();

    public AgentPool refresh();

    public AgentPool refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithUpgradeSettings {
            public Update withUpgradeSettings(AgentPoolUpgradeSettings var1);
        }

        public static interface WithCount {
            public Update withCount(Long var1);
        }

        public static interface WithAdministratorConfiguration {
            public Update withAdministratorConfiguration(NodePoolAdministratorConfigurationPatch var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithAdministratorConfiguration,
    UpdateStages.WithCount,
    UpdateStages.WithUpgradeSettings {
        public AgentPool apply();

        public AgentPool apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithUpgradeSettings {
            public WithCreate withUpgradeSettings(AgentPoolUpgradeSettings var1);
        }

        public static interface WithTaints {
            public WithCreate withTaints(List<KubernetesLabel> var1);
        }

        public static interface WithLabels {
            public WithCreate withLabels(List<KubernetesLabel> var1);
        }

        public static interface WithAvailabilityZones {
            public WithCreate withAvailabilityZones(List<String> var1);
        }

        public static interface WithAttachedNetworkConfiguration {
            public WithCreate withAttachedNetworkConfiguration(AttachedNetworkConfiguration var1);
        }

        public static interface WithAgentOptions {
            public WithCreate withAgentOptions(AgentOptions var1);
        }

        public static interface WithAdministratorConfiguration {
            public WithCreate withAdministratorConfiguration(AdministratorConfiguration var1);
        }

        public static interface WithExtendedLocation {
            public WithCreate withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithExtendedLocation,
        WithAdministratorConfiguration,
        WithAgentOptions,
        WithAttachedNetworkConfiguration,
        WithAvailabilityZones,
        WithLabels,
        WithTaints,
        WithUpgradeSettings {
            public AgentPool create();

            public AgentPool create(Context var1);
        }

        public static interface WithVmSkuName {
            public WithCreate withVmSkuName(String var1);
        }

        public static interface WithMode {
            public WithVmSkuName withMode(AgentPoolMode var1);
        }

        public static interface WithCount {
            public WithMode withCount(long var1);
        }

        public static interface WithParentResource {
            public WithCount withExistingKubernetesCluster(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCount,
    DefinitionStages.WithMode,
    DefinitionStages.WithVmSkuName,
    DefinitionStages.WithCreate {
    }
}

