/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.RackSkusClient;
import com.azure.resourcemanager.networkcloud.fluent.models.RackSkuInner;
import com.azure.resourcemanager.networkcloud.implementation.RackSkuImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.RackSku;
import com.azure.resourcemanager.networkcloud.models.RackSkus;

public final class RackSkusImpl
implements RackSkus {
    private static final ClientLogger LOGGER = new ClientLogger(RackSkusImpl.class);
    private final RackSkusClient innerClient;
    private final NetworkCloudManager serviceManager;

    public RackSkusImpl(RackSkusClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<RackSku> list() {
        PagedIterable<RackSkuInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RackSkuImpl((RackSkuInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<RackSku> list(Context context) {
        PagedIterable<RackSkuInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RackSkuImpl((RackSkuInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<RackSku> getWithResponse(String rackSkuName, Context context) {
        Response<RackSkuInner> inner = this.serviceClient().getWithResponse(rackSkuName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RackSkuImpl((RackSkuInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public RackSku get(String rackSkuName) {
        RackSkuInner inner = this.serviceClient().get(rackSkuName);
        if (inner != null) {
            return new RackSkuImpl(inner, this.manager());
        }
        return null;
    }

    private RackSkusClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }
}

