/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.L2NetworkInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.L2Network;
import com.azure.resourcemanager.networkcloud.models.L2NetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.L2NetworkPatchParameters;
import com.azure.resourcemanager.networkcloud.models.L2NetworkProvisioningState;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class L2NetworkImpl
implements L2Network,
L2Network.Definition,
L2Network.Update {
    private L2NetworkInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String l2NetworkName;
    private L2NetworkPatchParameters updateL2NetworkUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<String> associatedResourceIds() {
        List<String> inner = this.innerModel().associatedResourceIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String clusterId() {
        return this.innerModel().clusterId();
    }

    @Override
    public L2NetworkDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public List<String> hybridAksClustersAssociatedIds() {
        List<String> inner = this.innerModel().hybridAksClustersAssociatedIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public HybridAksPluginType hybridAksPluginType() {
        return this.innerModel().hybridAksPluginType();
    }

    @Override
    public String interfaceName() {
        return this.innerModel().interfaceName();
    }

    @Override
    public String l2IsolationDomainId() {
        return this.innerModel().l2IsolationDomainId();
    }

    @Override
    public L2NetworkProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<String> virtualMachinesAssociatedIds() {
        List<String> inner = this.innerModel().virtualMachinesAssociatedIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public L2NetworkInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public L2NetworkImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public L2Network create() {
        this.innerObject = this.serviceManager.serviceClient().getL2Networks().createOrUpdate(this.resourceGroupName, this.l2NetworkName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public L2Network create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getL2Networks().createOrUpdate(this.resourceGroupName, this.l2NetworkName, this.innerModel(), context);
        return this;
    }

    L2NetworkImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new L2NetworkInner();
        this.serviceManager = serviceManager;
        this.l2NetworkName = name;
    }

    @Override
    public L2NetworkImpl update() {
        this.updateL2NetworkUpdateParameters = new L2NetworkPatchParameters();
        return this;
    }

    @Override
    public L2Network apply() {
        this.innerObject = (L2NetworkInner)((Object)this.serviceManager.serviceClient().getL2Networks().updateWithResponse(this.resourceGroupName, this.l2NetworkName, this.updateL2NetworkUpdateParameters, Context.NONE).getValue());
        return this;
    }

    @Override
    public L2Network apply(Context context) {
        this.innerObject = (L2NetworkInner)((Object)this.serviceManager.serviceClient().getL2Networks().updateWithResponse(this.resourceGroupName, this.l2NetworkName, this.updateL2NetworkUpdateParameters, context).getValue());
        return this;
    }

    L2NetworkImpl(L2NetworkInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.l2NetworkName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "l2Networks");
    }

    @Override
    public L2Network refresh() {
        this.innerObject = (L2NetworkInner)((Object)this.serviceManager.serviceClient().getL2Networks().getByResourceGroupWithResponse(this.resourceGroupName, this.l2NetworkName, Context.NONE).getValue());
        return this;
    }

    @Override
    public L2Network refresh(Context context) {
        this.innerObject = (L2NetworkInner)((Object)this.serviceManager.serviceClient().getL2Networks().getByResourceGroupWithResponse(this.resourceGroupName, this.l2NetworkName, context).getValue());
        return this;
    }

    @Override
    public L2NetworkImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public L2NetworkImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public L2NetworkImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public L2NetworkImpl withL2IsolationDomainId(String l2IsolationDomainId) {
        this.innerModel().withL2IsolationDomainId(l2IsolationDomainId);
        return this;
    }

    @Override
    public L2NetworkImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateL2NetworkUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public L2NetworkImpl withHybridAksPluginType(HybridAksPluginType hybridAksPluginType) {
        this.innerModel().withHybridAksPluginType(hybridAksPluginType);
        return this;
    }

    @Override
    public L2NetworkImpl withInterfaceName(String interfaceName) {
        this.innerModel().withInterfaceName(interfaceName);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

