/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.ClusterManagersClient;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterManagerInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.ClusterManagerImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.ClusterManager;
import com.azure.resourcemanager.networkcloud.models.ClusterManagers;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class ClusterManagersImpl
implements ClusterManagers {
    private static final ClientLogger LOGGER = new ClientLogger(ClusterManagersImpl.class);
    private final ClusterManagersClient innerClient;
    private final NetworkCloudManager serviceManager;

    public ClusterManagersImpl(ClusterManagersClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ClusterManager> list() {
        PagedIterable<ClusterManagerInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterManagerImpl((ClusterManagerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ClusterManager> list(Context context) {
        PagedIterable<ClusterManagerInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterManagerImpl((ClusterManagerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ClusterManager> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ClusterManagerInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterManagerImpl((ClusterManagerInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ClusterManager> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ClusterManagerInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterManagerImpl((ClusterManagerInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ClusterManager> getByResourceGroupWithResponse(String resourceGroupName, String clusterManagerName, Context context) {
        Response<ClusterManagerInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, clusterManagerName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ClusterManagerImpl((ClusterManagerInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ClusterManager getByResourceGroup(String resourceGroupName, String clusterManagerName) {
        ClusterManagerInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, clusterManagerName);
        if (inner != null) {
            return new ClusterManagerImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String clusterManagerName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, clusterManagerName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String clusterManagerName, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, clusterManagerName, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ClusterManager getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterManagerName = ResourceManagerUtils.getValueFromIdByName(id, "clusterManagers");
        if (clusterManagerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusterManagers'.", id)));
        }
        return (ClusterManager)this.getByResourceGroupWithResponse(resourceGroupName, clusterManagerName, Context.NONE).getValue();
    }

    @Override
    public Response<ClusterManager> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterManagerName = ResourceManagerUtils.getValueFromIdByName(id, "clusterManagers");
        if (clusterManagerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusterManagers'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, clusterManagerName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterManagerName = ResourceManagerUtils.getValueFromIdByName(id, "clusterManagers");
        if (clusterManagerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusterManagers'.", id)));
        }
        return this.delete(resourceGroupName, clusterManagerName, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterManagerName = ResourceManagerUtils.getValueFromIdByName(id, "clusterManagers");
        if (clusterManagerName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusterManagers'.", id)));
        }
        return this.delete(resourceGroupName, clusterManagerName, context);
    }

    private ClusterManagersClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterManagerImpl define(String name) {
        return new ClusterManagerImpl(name, this.manager());
    }
}

