/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.networkcloud.fluent.BareMetalMachineKeySetsClient;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineKeySetInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudImpl;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetList;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetPatchParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BareMetalMachineKeySetsClientImpl
implements BareMetalMachineKeySetsClient {
    private final BareMetalMachineKeySetsService service;
    private final NetworkCloudImpl client;

    BareMetalMachineKeySetsClientImpl(NetworkCloudImpl client) {
        this.service = (BareMetalMachineKeySetsService)RestProxy.create(BareMetalMachineKeySetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineKeySetInner>> listByClusterSinglePageAsync(String resourceGroupName, String clusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByCluster(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineKeySetList)res.getValue()).value(), ((BareMetalMachineKeySetList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineKeySetInner>> listByClusterSinglePageAsync(String resourceGroupName, String clusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByCluster(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineKeySetList)res.getValue()).value(), ((BareMetalMachineKeySetList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BareMetalMachineKeySetInner> listByClusterAsync(String resourceGroupName, String clusterName) {
        return new PagedFlux(() -> this.listByClusterSinglePageAsync(resourceGroupName, clusterName), nextLink -> this.listByClusterNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BareMetalMachineKeySetInner> listByClusterAsync(String resourceGroupName, String clusterName, Context context) {
        return new PagedFlux(() -> this.listByClusterSinglePageAsync(resourceGroupName, clusterName, context), nextLink -> this.listByClusterNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BareMetalMachineKeySetInner> listByCluster(String resourceGroupName, String clusterName) {
        return new PagedIterable(this.listByClusterAsync(resourceGroupName, clusterName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BareMetalMachineKeySetInner> listByCluster(String resourceGroupName, String clusterName, Context context) {
        return new PagedIterable(this.listByClusterAsync(resourceGroupName, clusterName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BareMetalMachineKeySetInner>> getWithResponseAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineKeySetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, bareMetalMachineKeySetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BareMetalMachineKeySetInner>> getWithResponseAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineKeySetName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, bareMetalMachineKeySetName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineKeySetInner> getAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        return this.getWithResponseAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((BareMetalMachineKeySetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BareMetalMachineKeySetInner> getWithResponse(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineKeySetInner get(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        return (BareMetalMachineKeySetInner)((Object)this.getWithResponse(resourceGroupName, clusterName, bareMetalMachineKeySetName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetInner bareMetalMachineKeySetParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineKeySetName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineKeySetParameters is required and cannot be null."));
        }
        bareMetalMachineKeySetParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetInner bareMetalMachineKeySetParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineKeySetName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineKeySetParameters is required and cannot be null."));
        }
        bareMetalMachineKeySetParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineKeySetInner>, BareMetalMachineKeySetInner> beginCreateOrUpdateAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetInner bareMetalMachineKeySetParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineKeySetInner.class), (Type)((Object)BareMetalMachineKeySetInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineKeySetInner>, BareMetalMachineKeySetInner> beginCreateOrUpdateAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetInner bareMetalMachineKeySetParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineKeySetInner.class), (Type)((Object)BareMetalMachineKeySetInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineKeySetInner>, BareMetalMachineKeySetInner> beginCreateOrUpdate(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetInner bareMetalMachineKeySetParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineKeySetInner>, BareMetalMachineKeySetInner> beginCreateOrUpdate(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetInner bareMetalMachineKeySetParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineKeySetInner> createOrUpdateAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetInner bareMetalMachineKeySetParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineKeySetInner> createOrUpdateAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetInner bareMetalMachineKeySetParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineKeySetInner createOrUpdate(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetInner bareMetalMachineKeySetParameters) {
        return (BareMetalMachineKeySetInner)((Object)this.createOrUpdateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineKeySetInner createOrUpdate(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetInner bareMetalMachineKeySetParameters, Context context) {
        return (BareMetalMachineKeySetInner)((Object)this.createOrUpdateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineKeySetName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, bareMetalMachineKeySetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineKeySetName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, bareMetalMachineKeySetName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        return (OperationStatusResultInner)this.deleteAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, Context context) {
        return (OperationStatusResultInner)this.deleteAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineKeySetName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetUpdateParameters != null) {
            bareMetalMachineKeySetUpdateParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter bareMetalMachineKeySetName is required and cannot be null."));
        }
        if (bareMetalMachineKeySetUpdateParameters != null) {
            bareMetalMachineKeySetUpdateParameters.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineKeySetInner>, BareMetalMachineKeySetInner> beginUpdateAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineKeySetInner.class), (Type)((Object)BareMetalMachineKeySetInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineKeySetInner>, BareMetalMachineKeySetInner> beginUpdateAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineKeySetInner.class), (Type)((Object)BareMetalMachineKeySetInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BareMetalMachineKeySetInner>, BareMetalMachineKeySetInner> beginUpdateAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)BareMetalMachineKeySetInner.class), (Type)((Object)BareMetalMachineKeySetInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineKeySetInner>, BareMetalMachineKeySetInner> beginUpdate(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BareMetalMachineKeySetInner>, BareMetalMachineKeySetInner> beginUpdate(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineKeySetInner> updateAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineKeySetInner> updateAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<BareMetalMachineKeySetInner> updateAsync(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineKeySetInner update(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName) {
        BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters = null;
        return (BareMetalMachineKeySetInner)((Object)this.updateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BareMetalMachineKeySetInner update(String resourceGroupName, String clusterName, String bareMetalMachineKeySetName, BareMetalMachineKeySetPatchParameters bareMetalMachineKeySetUpdateParameters, Context context) {
        return (BareMetalMachineKeySetInner)((Object)this.updateAsync(resourceGroupName, clusterName, bareMetalMachineKeySetName, bareMetalMachineKeySetUpdateParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineKeySetInner>> listByClusterNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByClusterNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineKeySetList)res.getValue()).value(), ((BareMetalMachineKeySetList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BareMetalMachineKeySetInner>> listByClusterNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByClusterNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BareMetalMachineKeySetList)res.getValue()).value(), ((BareMetalMachineKeySetList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkCloudBareMeta")
    public static interface BareMetalMachineKeySetsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/bareMetalMachineKeySets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineKeySetList>> listByCluster(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/bareMetalMachineKeySets/{bareMetalMachineKeySetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineKeySetInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="bareMetalMachineKeySetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/bareMetalMachineKeySets/{bareMetalMachineKeySetName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="bareMetalMachineKeySetName") String var6, @BodyParam(value="application/json") BareMetalMachineKeySetInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/bareMetalMachineKeySets/{bareMetalMachineKeySetName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="bareMetalMachineKeySetName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/bareMetalMachineKeySets/{bareMetalMachineKeySetName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="clusterName") String var5, @PathParam(value="bareMetalMachineKeySetName") String var6, @BodyParam(value="application/json") BareMetalMachineKeySetPatchParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<BareMetalMachineKeySetList>> listByClusterNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

