/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.TrunkedNetworkProperties;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.TrunkedNetworkProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class TrunkedNetworkInner
extends Resource {
    private ExtendedLocation extendedLocation;
    private TrunkedNetworkProperties innerProperties = new TrunkedNetworkProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(TrunkedNetworkInner.class);

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public TrunkedNetworkInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private TrunkedNetworkProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public TrunkedNetworkInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public TrunkedNetworkInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<String> associatedResourceIds() {
        return this.innerProperties() == null ? null : this.innerProperties().associatedResourceIds();
    }

    public String clusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterId();
    }

    public TrunkedNetworkDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public List<String> hybridAksClustersAssociatedIds() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridAksClustersAssociatedIds();
    }

    public HybridAksPluginType hybridAksPluginType() {
        return this.innerProperties() == null ? null : this.innerProperties().hybridAksPluginType();
    }

    public TrunkedNetworkInner withHybridAksPluginType(HybridAksPluginType hybridAksPluginType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TrunkedNetworkProperties();
        }
        this.innerProperties().withHybridAksPluginType(hybridAksPluginType);
        return this;
    }

    public String interfaceName() {
        return this.innerProperties() == null ? null : this.innerProperties().interfaceName();
    }

    public TrunkedNetworkInner withInterfaceName(String interfaceName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TrunkedNetworkProperties();
        }
        this.innerProperties().withInterfaceName(interfaceName);
        return this;
    }

    public List<String> isolationDomainIds() {
        return this.innerProperties() == null ? null : this.innerProperties().isolationDomainIds();
    }

    public TrunkedNetworkInner withIsolationDomainIds(List<String> isolationDomainIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TrunkedNetworkProperties();
        }
        this.innerProperties().withIsolationDomainIds(isolationDomainIds);
        return this;
    }

    public TrunkedNetworkProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<String> virtualMachinesAssociatedIds() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachinesAssociatedIds();
    }

    public List<Long> vlans() {
        return this.innerProperties() == null ? null : this.innerProperties().vlans();
    }

    public TrunkedNetworkInner withVlans(List<Long> vlans) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TrunkedNetworkProperties();
        }
        this.innerProperties().withVlans(vlans);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model TrunkedNetworkInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model TrunkedNetworkInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static TrunkedNetworkInner fromJson(JsonReader jsonReader) throws IOException {
        return (TrunkedNetworkInner)((Object)jsonReader.readObject(reader -> {
            TrunkedNetworkInner deserializedTrunkedNetworkInner = new TrunkedNetworkInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTrunkedNetworkInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTrunkedNetworkInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTrunkedNetworkInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedTrunkedNetworkInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedTrunkedNetworkInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedTrunkedNetworkInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTrunkedNetworkInner.innerProperties = TrunkedNetworkProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedTrunkedNetworkInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrunkedNetworkInner;
        }));
    }
}

