/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.HybridAksPluginType;
import com.azure.resourcemanager.networkcloud.models.L2NetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.L2NetworkProvisioningState;
import java.io.IOException;
import java.util.List;

public final class L2NetworkProperties
implements JsonSerializable<L2NetworkProperties> {
    private List<String> associatedResourceIds;
    private String clusterId;
    private L2NetworkDetailedStatus detailedStatus;
    private String detailedStatusMessage;
    private List<String> hybridAksClustersAssociatedIds;
    private HybridAksPluginType hybridAksPluginType;
    private String interfaceName;
    private String l2IsolationDomainId;
    private L2NetworkProvisioningState provisioningState;
    private List<String> virtualMachinesAssociatedIds;
    private static final ClientLogger LOGGER = new ClientLogger(L2NetworkProperties.class);

    public List<String> associatedResourceIds() {
        return this.associatedResourceIds;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public L2NetworkDetailedStatus detailedStatus() {
        return this.detailedStatus;
    }

    public String detailedStatusMessage() {
        return this.detailedStatusMessage;
    }

    public List<String> hybridAksClustersAssociatedIds() {
        return this.hybridAksClustersAssociatedIds;
    }

    public HybridAksPluginType hybridAksPluginType() {
        return this.hybridAksPluginType;
    }

    public L2NetworkProperties withHybridAksPluginType(HybridAksPluginType hybridAksPluginType) {
        this.hybridAksPluginType = hybridAksPluginType;
        return this;
    }

    public String interfaceName() {
        return this.interfaceName;
    }

    public L2NetworkProperties withInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
        return this;
    }

    public String l2IsolationDomainId() {
        return this.l2IsolationDomainId;
    }

    public L2NetworkProperties withL2IsolationDomainId(String l2IsolationDomainId) {
        this.l2IsolationDomainId = l2IsolationDomainId;
        return this;
    }

    public L2NetworkProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<String> virtualMachinesAssociatedIds() {
        return this.virtualMachinesAssociatedIds;
    }

    public void validate() {
        if (this.l2IsolationDomainId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property l2IsolationDomainId in model L2NetworkProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("l2IsolationDomainId", this.l2IsolationDomainId);
        jsonWriter.writeStringField("hybridAksPluginType", this.hybridAksPluginType == null ? null : this.hybridAksPluginType.toString());
        jsonWriter.writeStringField("interfaceName", this.interfaceName);
        return jsonWriter.writeEndObject();
    }

    public static L2NetworkProperties fromJson(JsonReader jsonReader) throws IOException {
        return (L2NetworkProperties)jsonReader.readObject(reader -> {
            L2NetworkProperties deserializedL2NetworkProperties = new L2NetworkProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("l2IsolationDomainId".equals(fieldName)) {
                    deserializedL2NetworkProperties.l2IsolationDomainId = reader.getString();
                    continue;
                }
                if ("associatedResourceIds".equals(fieldName)) {
                    List associatedResourceIds;
                    deserializedL2NetworkProperties.associatedResourceIds = associatedResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedL2NetworkProperties.clusterId = reader.getString();
                    continue;
                }
                if ("detailedStatus".equals(fieldName)) {
                    deserializedL2NetworkProperties.detailedStatus = L2NetworkDetailedStatus.fromString(reader.getString());
                    continue;
                }
                if ("detailedStatusMessage".equals(fieldName)) {
                    deserializedL2NetworkProperties.detailedStatusMessage = reader.getString();
                    continue;
                }
                if ("hybridAksClustersAssociatedIds".equals(fieldName)) {
                    List hybridAksClustersAssociatedIds;
                    deserializedL2NetworkProperties.hybridAksClustersAssociatedIds = hybridAksClustersAssociatedIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("hybridAksPluginType".equals(fieldName)) {
                    deserializedL2NetworkProperties.hybridAksPluginType = HybridAksPluginType.fromString(reader.getString());
                    continue;
                }
                if ("interfaceName".equals(fieldName)) {
                    deserializedL2NetworkProperties.interfaceName = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedL2NetworkProperties.provisioningState = L2NetworkProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("virtualMachinesAssociatedIds".equals(fieldName)) {
                    List virtualMachinesAssociatedIds;
                    deserializedL2NetworkProperties.virtualMachinesAssociatedIds = virtualMachinesAssociatedIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedL2NetworkProperties;
        });
    }
}

