/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AnalyticsOutputSettings;
import com.azure.resourcemanager.networkcloud.models.ClusterSecretArchive;
import com.azure.resourcemanager.networkcloud.models.ClusterUpdateStrategy;
import com.azure.resourcemanager.networkcloud.models.CommandOutputSettings;
import com.azure.resourcemanager.networkcloud.models.RackDefinition;
import com.azure.resourcemanager.networkcloud.models.RuntimeProtectionConfiguration;
import com.azure.resourcemanager.networkcloud.models.SecretArchiveSettings;
import com.azure.resourcemanager.networkcloud.models.ServicePrincipalInformation;
import com.azure.resourcemanager.networkcloud.models.ValidationThreshold;
import com.azure.resourcemanager.networkcloud.models.VulnerabilityScanningSettingsPatch;
import java.io.IOException;
import java.util.List;

public final class ClusterPatchProperties
implements JsonSerializable<ClusterPatchProperties> {
    private RackDefinition aggregatorOrSingleRackDefinition;
    private AnalyticsOutputSettings analyticsOutputSettings;
    private String clusterLocation;
    private ServicePrincipalInformation clusterServicePrincipal;
    private CommandOutputSettings commandOutputSettings;
    private ValidationThreshold computeDeploymentThreshold;
    private List<RackDefinition> computeRackDefinitions;
    private RuntimeProtectionConfiguration runtimeProtectionConfiguration;
    private ClusterSecretArchive secretArchive;
    private SecretArchiveSettings secretArchiveSettings;
    private ClusterUpdateStrategy updateStrategy;
    private VulnerabilityScanningSettingsPatch vulnerabilityScanningSettings;

    public RackDefinition aggregatorOrSingleRackDefinition() {
        return this.aggregatorOrSingleRackDefinition;
    }

    public ClusterPatchProperties withAggregatorOrSingleRackDefinition(RackDefinition aggregatorOrSingleRackDefinition) {
        this.aggregatorOrSingleRackDefinition = aggregatorOrSingleRackDefinition;
        return this;
    }

    public AnalyticsOutputSettings analyticsOutputSettings() {
        return this.analyticsOutputSettings;
    }

    public ClusterPatchProperties withAnalyticsOutputSettings(AnalyticsOutputSettings analyticsOutputSettings) {
        this.analyticsOutputSettings = analyticsOutputSettings;
        return this;
    }

    public String clusterLocation() {
        return this.clusterLocation;
    }

    public ClusterPatchProperties withClusterLocation(String clusterLocation) {
        this.clusterLocation = clusterLocation;
        return this;
    }

    public ServicePrincipalInformation clusterServicePrincipal() {
        return this.clusterServicePrincipal;
    }

    public ClusterPatchProperties withClusterServicePrincipal(ServicePrincipalInformation clusterServicePrincipal) {
        this.clusterServicePrincipal = clusterServicePrincipal;
        return this;
    }

    public CommandOutputSettings commandOutputSettings() {
        return this.commandOutputSettings;
    }

    public ClusterPatchProperties withCommandOutputSettings(CommandOutputSettings commandOutputSettings) {
        this.commandOutputSettings = commandOutputSettings;
        return this;
    }

    public ValidationThreshold computeDeploymentThreshold() {
        return this.computeDeploymentThreshold;
    }

    public ClusterPatchProperties withComputeDeploymentThreshold(ValidationThreshold computeDeploymentThreshold) {
        this.computeDeploymentThreshold = computeDeploymentThreshold;
        return this;
    }

    public List<RackDefinition> computeRackDefinitions() {
        return this.computeRackDefinitions;
    }

    public ClusterPatchProperties withComputeRackDefinitions(List<RackDefinition> computeRackDefinitions) {
        this.computeRackDefinitions = computeRackDefinitions;
        return this;
    }

    public RuntimeProtectionConfiguration runtimeProtectionConfiguration() {
        return this.runtimeProtectionConfiguration;
    }

    public ClusterPatchProperties withRuntimeProtectionConfiguration(RuntimeProtectionConfiguration runtimeProtectionConfiguration) {
        this.runtimeProtectionConfiguration = runtimeProtectionConfiguration;
        return this;
    }

    public ClusterSecretArchive secretArchive() {
        return this.secretArchive;
    }

    public ClusterPatchProperties withSecretArchive(ClusterSecretArchive secretArchive) {
        this.secretArchive = secretArchive;
        return this;
    }

    public SecretArchiveSettings secretArchiveSettings() {
        return this.secretArchiveSettings;
    }

    public ClusterPatchProperties withSecretArchiveSettings(SecretArchiveSettings secretArchiveSettings) {
        this.secretArchiveSettings = secretArchiveSettings;
        return this;
    }

    public ClusterUpdateStrategy updateStrategy() {
        return this.updateStrategy;
    }

    public ClusterPatchProperties withUpdateStrategy(ClusterUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
        return this;
    }

    public VulnerabilityScanningSettingsPatch vulnerabilityScanningSettings() {
        return this.vulnerabilityScanningSettings;
    }

    public ClusterPatchProperties withVulnerabilityScanningSettings(VulnerabilityScanningSettingsPatch vulnerabilityScanningSettings) {
        this.vulnerabilityScanningSettings = vulnerabilityScanningSettings;
        return this;
    }

    public void validate() {
        if (this.aggregatorOrSingleRackDefinition() != null) {
            this.aggregatorOrSingleRackDefinition().validate();
        }
        if (this.analyticsOutputSettings() != null) {
            this.analyticsOutputSettings().validate();
        }
        if (this.clusterServicePrincipal() != null) {
            this.clusterServicePrincipal().validate();
        }
        if (this.commandOutputSettings() != null) {
            this.commandOutputSettings().validate();
        }
        if (this.computeDeploymentThreshold() != null) {
            this.computeDeploymentThreshold().validate();
        }
        if (this.computeRackDefinitions() != null) {
            this.computeRackDefinitions().forEach(e -> e.validate());
        }
        if (this.runtimeProtectionConfiguration() != null) {
            this.runtimeProtectionConfiguration().validate();
        }
        if (this.secretArchive() != null) {
            this.secretArchive().validate();
        }
        if (this.secretArchiveSettings() != null) {
            this.secretArchiveSettings().validate();
        }
        if (this.updateStrategy() != null) {
            this.updateStrategy().validate();
        }
        if (this.vulnerabilityScanningSettings() != null) {
            this.vulnerabilityScanningSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("aggregatorOrSingleRackDefinition", (JsonSerializable)this.aggregatorOrSingleRackDefinition);
        jsonWriter.writeJsonField("analyticsOutputSettings", (JsonSerializable)this.analyticsOutputSettings);
        jsonWriter.writeStringField("clusterLocation", this.clusterLocation);
        jsonWriter.writeJsonField("clusterServicePrincipal", (JsonSerializable)this.clusterServicePrincipal);
        jsonWriter.writeJsonField("commandOutputSettings", (JsonSerializable)this.commandOutputSettings);
        jsonWriter.writeJsonField("computeDeploymentThreshold", (JsonSerializable)this.computeDeploymentThreshold);
        jsonWriter.writeArrayField("computeRackDefinitions", this.computeRackDefinitions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("runtimeProtectionConfiguration", (JsonSerializable)this.runtimeProtectionConfiguration);
        jsonWriter.writeJsonField("secretArchive", (JsonSerializable)this.secretArchive);
        jsonWriter.writeJsonField("secretArchiveSettings", (JsonSerializable)this.secretArchiveSettings);
        jsonWriter.writeJsonField("updateStrategy", (JsonSerializable)this.updateStrategy);
        jsonWriter.writeJsonField("vulnerabilityScanningSettings", (JsonSerializable)this.vulnerabilityScanningSettings);
        return jsonWriter.writeEndObject();
    }

    public static ClusterPatchProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterPatchProperties)jsonReader.readObject(reader -> {
            ClusterPatchProperties deserializedClusterPatchProperties = new ClusterPatchProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("aggregatorOrSingleRackDefinition".equals(fieldName)) {
                    deserializedClusterPatchProperties.aggregatorOrSingleRackDefinition = RackDefinition.fromJson(reader);
                    continue;
                }
                if ("analyticsOutputSettings".equals(fieldName)) {
                    deserializedClusterPatchProperties.analyticsOutputSettings = AnalyticsOutputSettings.fromJson(reader);
                    continue;
                }
                if ("clusterLocation".equals(fieldName)) {
                    deserializedClusterPatchProperties.clusterLocation = reader.getString();
                    continue;
                }
                if ("clusterServicePrincipal".equals(fieldName)) {
                    deserializedClusterPatchProperties.clusterServicePrincipal = ServicePrincipalInformation.fromJson(reader);
                    continue;
                }
                if ("commandOutputSettings".equals(fieldName)) {
                    deserializedClusterPatchProperties.commandOutputSettings = CommandOutputSettings.fromJson(reader);
                    continue;
                }
                if ("computeDeploymentThreshold".equals(fieldName)) {
                    deserializedClusterPatchProperties.computeDeploymentThreshold = ValidationThreshold.fromJson(reader);
                    continue;
                }
                if ("computeRackDefinitions".equals(fieldName)) {
                    List computeRackDefinitions;
                    deserializedClusterPatchProperties.computeRackDefinitions = computeRackDefinitions = reader.readArray(reader1 -> RackDefinition.fromJson(reader1));
                    continue;
                }
                if ("runtimeProtectionConfiguration".equals(fieldName)) {
                    deserializedClusterPatchProperties.runtimeProtectionConfiguration = RuntimeProtectionConfiguration.fromJson(reader);
                    continue;
                }
                if ("secretArchive".equals(fieldName)) {
                    deserializedClusterPatchProperties.secretArchive = ClusterSecretArchive.fromJson(reader);
                    continue;
                }
                if ("secretArchiveSettings".equals(fieldName)) {
                    deserializedClusterPatchProperties.secretArchiveSettings = SecretArchiveSettings.fromJson(reader);
                    continue;
                }
                if ("updateStrategy".equals(fieldName)) {
                    deserializedClusterPatchProperties.updateStrategy = ClusterUpdateStrategy.fromJson(reader);
                    continue;
                }
                if ("vulnerabilityScanningSettings".equals(fieldName)) {
                    deserializedClusterPatchProperties.vulnerabilityScanningSettings = VulnerabilityScanningSettingsPatch.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterPatchProperties;
        });
    }
}

