/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.HttpHeader;
import com.azure.resourcemanager.network.models.HttpMethod;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class HttpConfiguration {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(HttpConfiguration.class);
    @JsonProperty(value="method")
    private HttpMethod method;
    @JsonProperty(value="headers")
    private List<HttpHeader> headers;
    @JsonProperty(value="validStatusCodes")
    private List<Integer> validStatusCodes;

    public HttpMethod method() {
        return this.method;
    }

    public HttpConfiguration withMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public List<HttpHeader> headers() {
        return this.headers;
    }

    public HttpConfiguration withHeaders(List<HttpHeader> headers) {
        this.headers = headers;
        return this;
    }

    public List<Integer> validStatusCodes() {
        return this.validStatusCodes;
    }

    public HttpConfiguration withValidStatusCodes(List<Integer> validStatusCodes) {
        this.validStatusCodes = validStatusCodes;
        return this;
    }

    public void validate() {
        if (this.headers() != null) {
            this.headers().forEach(e -> e.validate());
        }
    }
}

