/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.management.Resource;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.IpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.PublicIpAddressInner;
import com.azure.resourcemanager.network.models.AppliableWithTags;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.IpTag;
import com.azure.resourcemanager.network.models.IpVersion;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerPublicFrontend;
import com.azure.resourcemanager.network.models.NetworkInterface;
import com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.azure.resourcemanager.network.models.PublicIPSkuType;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.network.models.PublicIpAddressDnsSettings;
import com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class PublicIpAddressImpl
extends GroupableResourceImpl<PublicIpAddress, PublicIpAddressInner, PublicIpAddressImpl, NetworkManager>
implements PublicIpAddress,
PublicIpAddress.Definition,
PublicIpAddress.Update,
AppliableWithTags<PublicIpAddress> {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    PublicIpAddressImpl(String name, PublicIpAddressInner innerModel, NetworkManager networkManager) {
        super(name, (Resource)innerModel, (Manager)networkManager);
    }

    protected Mono<PublicIpAddressInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpAddresses().getByResourceGroupAsync(this.resourceGroupName(), this.name(), null);
    }

    @Override
    public PublicIpAddressImpl withIdleTimeoutInMinutes(int minutes) {
        ((PublicIpAddressInner)((Object)this.innerModel())).withIdleTimeoutInMinutes(minutes);
        return this;
    }

    @Override
    public PublicIpAddressImpl withStaticIP() {
        ((PublicIpAddressInner)((Object)this.innerModel())).withPublicIpAllocationMethod(IpAllocationMethod.STATIC);
        return this;
    }

    @Override
    public PublicIpAddressImpl withDynamicIP() {
        ((PublicIpAddressInner)((Object)this.innerModel())).withPublicIpAllocationMethod(IpAllocationMethod.DYNAMIC);
        return this;
    }

    @Override
    public PublicIpAddressImpl withLeafDomainLabel(String dnsName) {
        if (((PublicIpAddressInner)((Object)this.innerModel())).dnsSettings() == null) {
            ((PublicIpAddressInner)((Object)this.innerModel())).withDnsSettings(new PublicIpAddressDnsSettings());
        }
        ((PublicIpAddressInner)((Object)this.innerModel())).dnsSettings().withDomainNameLabel(dnsName == null ? null : dnsName.toLowerCase(Locale.ROOT));
        return this;
    }

    @Override
    public PublicIpAddressImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (((PublicIpAddressInner)((Object)this.innerModel())).zones() == null) {
            ((PublicIpAddressInner)((Object)this.innerModel())).withZones(new ArrayList<String>());
        }
        ((PublicIpAddressInner)((Object)this.innerModel())).zones().add(zoneId.toString());
        return this;
    }

    @Override
    public PublicIpAddressImpl withSku(PublicIPSkuType skuType) {
        ((PublicIpAddressInner)((Object)this.innerModel())).withSku(skuType.sku());
        return this;
    }

    @Override
    public PublicIpAddressImpl withoutLeafDomainLabel() {
        ((PublicIpAddressInner)((Object)this.innerModel())).withDnsSettings(null);
        return this;
    }

    @Override
    public PublicIpAddressImpl withReverseFqdn(String reverseFqdn) {
        if (((PublicIpAddressInner)((Object)this.innerModel())).dnsSettings() == null) {
            ((PublicIpAddressInner)((Object)this.innerModel())).withDnsSettings(new PublicIpAddressDnsSettings());
        }
        ((PublicIpAddressInner)((Object)this.innerModel())).dnsSettings().withReverseFqdn(reverseFqdn != null ? reverseFqdn.toLowerCase(Locale.ROOT) : null);
        return this;
    }

    @Override
    public PublicIpAddressImpl withoutReverseFqdn() {
        return this.withReverseFqdn(null);
    }

    @Override
    public int idleTimeoutInMinutes() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((PublicIpAddressInner)((Object)this.innerModel())).idleTimeoutInMinutes());
    }

    @Override
    public IpAllocationMethod ipAllocationMethod() {
        return ((PublicIpAddressInner)((Object)this.innerModel())).publicIpAllocationMethod();
    }

    @Override
    public IpVersion version() {
        return ((PublicIpAddressInner)((Object)this.innerModel())).publicIpAddressVersion();
    }

    @Override
    public String fqdn() {
        if (((PublicIpAddressInner)((Object)this.innerModel())).dnsSettings() != null) {
            return ((PublicIpAddressInner)((Object)this.innerModel())).dnsSettings().fqdn();
        }
        return null;
    }

    @Override
    public String reverseFqdn() {
        if (((PublicIpAddressInner)((Object)this.innerModel())).dnsSettings() != null) {
            return ((PublicIpAddressInner)((Object)this.innerModel())).dnsSettings().reverseFqdn();
        }
        return null;
    }

    @Override
    public String ipAddress() {
        return ((PublicIpAddressInner)((Object)this.innerModel())).ipAddress();
    }

    @Override
    public String leafDomainLabel() {
        if (((PublicIpAddressInner)((Object)this.innerModel())).dnsSettings() == null) {
            return null;
        }
        return ((PublicIpAddressInner)((Object)this.innerModel())).dnsSettings().domainNameLabel();
    }

    @Override
    public Accepted<PublicIpAddress> beginCreate() {
        return AcceptedImpl.newAccepted((ClientLogger)this.logger, (HttpPipeline)((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getHttpPipeline(), (Duration)((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpAddresses().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.name(), (PublicIpAddressInner)((Object)((Object)this.innerModel()))).block(), inner -> new PublicIpAddressImpl(inner.name(), (PublicIpAddressInner)((Object)inner), (NetworkManager)this.manager()), PublicIpAddressInner.class, () -> {
            Flux dependencyTasksAsync = this.taskGroup().invokeDependencyAsync(this.taskGroup().newInvocationContext());
            dependencyTasksAsync.blockLast();
            this.cleanupDnsSettings();
        }, arg_0 -> ((PublicIpAddressImpl)this).setInner(arg_0), (Context)Context.NONE);
    }

    public Mono<PublicIpAddress> createResourceAsync() {
        this.cleanupDnsSettings();
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpAddresses().createOrUpdateAsync(this.resourceGroupName(), this.name(), (PublicIpAddressInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    private void cleanupDnsSettings() {
        PublicIpAddressDnsSettings dnsSettings = ((PublicIpAddressInner)((Object)this.innerModel())).dnsSettings();
        if (!(dnsSettings == null || dnsSettings.domainNameLabel() != null && !dnsSettings.domainNameLabel().isEmpty() || dnsSettings.fqdn() != null && !dnsSettings.fqdn().isEmpty() || dnsSettings.reverseFqdn() != null && !dnsSettings.reverseFqdn().isEmpty())) {
            ((PublicIpAddressInner)((Object)this.innerModel())).withDnsSettings(null);
        }
    }

    private boolean equalsResourceType(String resourceType) {
        IpConfigurationInner ipConfig = ((PublicIpAddressInner)((Object)this.innerModel())).ipConfiguration();
        if (ipConfig == null || resourceType == null) {
            return false;
        }
        String refId = ((PublicIpAddressInner)((Object)this.innerModel())).ipConfiguration().id();
        String resourceType2 = ResourceUtils.resourceTypeFromResourceId((String)refId);
        return resourceType.equalsIgnoreCase(resourceType2);
    }

    @Override
    public boolean hasAssignedLoadBalancer() {
        return this.equalsResourceType("frontendIPConfigurations");
    }

    @Override
    public LoadBalancerPublicFrontend getAssignedLoadBalancerFrontend() {
        if (this.hasAssignedLoadBalancer()) {
            String refId = ((PublicIpAddressInner)((Object)this.innerModel())).ipConfiguration().id();
            String loadBalancerId = ResourceUtils.parentResourceIdFromResourceId((String)refId);
            LoadBalancer lb = (LoadBalancer)((NetworkManager)this.myManager).loadBalancers().getById(loadBalancerId);
            String frontendName = ResourceUtils.nameFromResourceId((String)refId);
            return (LoadBalancerPublicFrontend)lb.frontends().get(frontendName);
        }
        return null;
    }

    @Override
    public boolean hasAssignedNetworkInterface() {
        return this.equalsResourceType("ipConfigurations");
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((PublicIpAddressInner)((Object)this.innerModel())).zones() != null) {
            for (String zone : ((PublicIpAddressInner)((Object)this.innerModel())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public PublicIPSkuType sku() {
        return PublicIPSkuType.fromSku(((PublicIpAddressInner)((Object)this.innerModel())).sku());
    }

    @Override
    public List<IpTag> ipTags() {
        return Collections.unmodifiableList(((PublicIpAddressInner)((Object)this.innerModel())).ipTags() == null ? new ArrayList() : ((PublicIpAddressInner)((Object)this.innerModel())).ipTags());
    }

    @Override
    public NicIpConfiguration getAssignedNetworkInterfaceIPConfiguration() {
        if (this.hasAssignedNetworkInterface()) {
            String refId = ((PublicIpAddressInner)((Object)this.innerModel())).ipConfiguration().id();
            String parentId = ResourceUtils.parentResourceIdFromResourceId((String)refId);
            NetworkInterface nic = (NetworkInterface)((NetworkManager)this.myManager).networkInterfaces().getById(parentId);
            String childName = ResourceUtils.nameFromResourceId((String)refId);
            return nic.ipConfigurations().get(childName);
        }
        return null;
    }

    public PublicIpAddressImpl updateTags() {
        return this;
    }

    @Override
    public PublicIpAddress applyTags() {
        return (PublicIpAddress)this.applyTagsAsync().block();
    }

    @Override
    public Mono<PublicIpAddress> applyTagsAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPublicIpAddresses().updateTagsAsync(this.resourceGroupName(), this.name(), ((PublicIpAddressInner)((Object)this.innerModel())).tags()).flatMap(inner -> {
            this.setInner(inner);
            return Mono.just((Object)this);
        });
    }

    @Override
    public PublicIpAddressImpl withIpTag(String tag) {
        if (((PublicIpAddressInner)((Object)this.innerModel())).ipTags() == null) {
            ((PublicIpAddressInner)((Object)this.innerModel())).withIpTags(new ArrayList<IpTag>());
        }
        this.ipTags().add(new IpTag().withTag(tag));
        return this;
    }

    @Override
    public PublicIpAddressImpl withIpTag(String tag, String ipTagType) {
        if (((PublicIpAddressInner)((Object)this.innerModel())).ipTags() == null) {
            ((PublicIpAddressInner)((Object)this.innerModel())).withIpTags(new ArrayList<IpTag>());
        }
        ((PublicIpAddressInner)((Object)this.innerModel())).ipTags().add(new IpTag().withTag(tag).withIpTagType(ipTagType));
        return this;
    }

    @Override
    public PublicIpAddressImpl withoutIpTag(String tag) {
        if (tag != null && ((PublicIpAddressInner)((Object)this.innerModel())).ipTags() != null) {
            for (IpTag ipTag : ((PublicIpAddressInner)((Object)this.innerModel())).ipTags()) {
                if (!tag.equals(ipTag.tag())) continue;
                ((PublicIpAddressInner)((Object)this.innerModel())).ipTags().remove(ipTag);
                return this;
            }
        }
        return this;
    }

    @Override
    public PublicIpAddressImpl withIpAddressVersion(IpVersion ipVersion) {
        ((PublicIpAddressInner)((Object)this.innerModel())).withPublicIpAddressVersion(ipVersion);
        return this;
    }
}

