/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.BackendAddressPoolInner;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.InboundNatRuleInner;
import com.azure.resourcemanager.network.fluent.models.LoadBalancerInner;
import com.azure.resourcemanager.network.fluent.models.LoadBalancingRuleInner;
import com.azure.resourcemanager.network.fluent.models.ProbeInner;
import com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.azure.resourcemanager.network.implementation.LoadBalancerBackendImpl;
import com.azure.resourcemanager.network.implementation.LoadBalancerFrontendImpl;
import com.azure.resourcemanager.network.implementation.LoadBalancerInboundNatPoolImpl;
import com.azure.resourcemanager.network.implementation.LoadBalancerInboundNatRuleImpl;
import com.azure.resourcemanager.network.implementation.LoadBalancerProbeImpl;
import com.azure.resourcemanager.network.implementation.LoadBalancingRuleImpl;
import com.azure.resourcemanager.network.models.HasNetworkInterfaces;
import com.azure.resourcemanager.network.models.InboundNatPool;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerBackend;
import com.azure.resourcemanager.network.models.LoadBalancerFrontend;
import com.azure.resourcemanager.network.models.LoadBalancerHttpProbe;
import com.azure.resourcemanager.network.models.LoadBalancerInboundNatPool;
import com.azure.resourcemanager.network.models.LoadBalancerInboundNatRule;
import com.azure.resourcemanager.network.models.LoadBalancerPrivateFrontend;
import com.azure.resourcemanager.network.models.LoadBalancerProbe;
import com.azure.resourcemanager.network.models.LoadBalancerPublicFrontend;
import com.azure.resourcemanager.network.models.LoadBalancerSkuType;
import com.azure.resourcemanager.network.models.LoadBalancerTcpProbe;
import com.azure.resourcemanager.network.models.LoadBalancingRule;
import com.azure.resourcemanager.network.models.NetworkInterface;
import com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.azure.resourcemanager.network.models.ProbeProtocol;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LoadBalancerImpl
extends GroupableParentResourceWithTagsImpl<LoadBalancer, LoadBalancerInner, LoadBalancerImpl, NetworkManager>
implements LoadBalancer,
LoadBalancer.Definition,
LoadBalancer.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final Map<String, String> nicsInBackends = new HashMap<String, String>();
    protected final Map<String, String> creatablePIPKeys = new HashMap<String, String>();
    private Map<String, LoadBalancerBackend> backends;
    private Map<String, LoadBalancerTcpProbe> tcpProbes;
    private Map<String, LoadBalancerHttpProbe> httpProbes;
    private Map<String, LoadBalancerHttpProbe> httpsProbes;
    private Map<String, LoadBalancingRule> loadBalancingRules;
    private Map<String, LoadBalancerFrontend> frontends;
    private Map<String, LoadBalancerInboundNatRule> inboundNatRules;
    private Map<String, LoadBalancerInboundNatPool> inboundNatPools;

    LoadBalancerImpl(String name, LoadBalancerInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
    }

    public Mono<LoadBalancer> refreshAsync() {
        return super.refreshAsync().map(loadBalancer -> {
            LoadBalancerImpl impl = (LoadBalancerImpl)loadBalancer;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    protected Mono<LoadBalancerInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getLoadBalancers().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    protected Mono<LoadBalancerInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getLoadBalancers().updateTagsAsync(this.resourceGroupName(), this.name(), ((LoadBalancerInner)((Object)this.innerModel())).tags());
    }

    protected void initializeChildrenFromInner() {
        this.initializeFrontendsFromInner();
        this.initializeProbesFromInner();
        this.initializeBackendsFromInner();
        this.initializeLoadBalancingRulesFromInner();
        this.initializeInboundNatRulesFromInner();
        this.initializeInboundNatPoolsFromInner();
    }

    protected LoadBalancerBackendImpl ensureUniqueBackend() {
        String name = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("backend", 20);
        LoadBalancerBackendImpl backend = this.defineBackend(name);
        backend.attach();
        return backend;
    }

    protected SubResource ensureFrontendRef(String name) {
        LoadBalancerFrontendImpl frontend;
        if (name == null) {
            frontend = this.ensureUniqueFrontend();
        } else {
            frontend = this.defineFrontend(name);
            frontend.attach();
        }
        return new SubResource().withId(this.futureResourceId() + "/frontendIpConfigurations/" + frontend.name());
    }

    protected LoadBalancerFrontendImpl ensureUniqueFrontend() {
        String name = ((NetworkManager)this.manager()).resourceManager().internalContext().randomResourceName("frontend", 20);
        LoadBalancerFrontendImpl frontend = this.defineFrontend(name);
        frontend.attach();
        return frontend;
    }

    LoadBalancerPrivateFrontend findPrivateFrontendWithSubnet(String networkId, String subnetName) {
        if (null == networkId || null == subnetName) {
            return null;
        }
        for (LoadBalancerPrivateFrontend frontend : this.privateFrontends().values()) {
            if (frontend.networkId() == null || frontend.subnetName() == null || !networkId.equalsIgnoreCase(frontend.networkId()) || !subnetName.equalsIgnoreCase(frontend.subnetName())) continue;
            return frontend;
        }
        return null;
    }

    LoadBalancerPrivateFrontend ensurePrivateFrontendWithSubnet(String networkId, String subnetName) {
        LoadBalancerPrivateFrontend frontend = this.findPrivateFrontendWithSubnet(networkId, subnetName);
        if (networkId == null || subnetName == null) {
            return null;
        }
        if (frontend != null) {
            return frontend;
        }
        LoadBalancerFrontendImpl fe = this.ensureUniqueFrontend().withExistingSubnet(networkId, subnetName).withPrivateIpAddressDynamic();
        fe.attach();
        return fe;
    }

    LoadBalancerPublicFrontend ensurePublicFrontendWithPip(String pipId) {
        LoadBalancerPublicFrontend frontend = this.findFrontendByPublicIpAddress(pipId);
        if (pipId == null) {
            return null;
        }
        if (frontend != null) {
            return frontend;
        }
        LoadBalancerFrontendImpl fe = this.ensureUniqueFrontend().withExistingPublicIpAddress(pipId);
        fe.attach();
        return fe;
    }

    /*
     * WARNING - void declaration
     */
    protected void beforeCreating() {
        void var6_10;
        if (this.creatablePIPKeys != null) {
            for (Map.Entry<String, String> pipFrontendAssociation : this.creatablePIPKeys.entrySet()) {
                PublicIpAddress pip = (PublicIpAddress)this.taskResult(pipFrontendAssociation.getKey());
                if (pip == null) continue;
                this.withExistingPublicIPAddress(pip.id(), pipFrontendAssociation.getValue());
            }
            this.creatablePIPKeys.clear();
        }
        List<ProbeInner> innerProbes = this.innersFromWrappers(this.httpProbes.values());
        innerProbes = this.innersFromWrappers(this.httpsProbes.values(), innerProbes);
        innerProbes = this.innersFromWrappers(this.tcpProbes.values(), innerProbes);
        if (innerProbes == null) {
            innerProbes = new ArrayList<ProbeInner>();
        }
        ((LoadBalancerInner)((Object)this.innerModel())).withProbes(innerProbes);
        ArrayList<BackendAddressPoolInner> innerBackends = this.innersFromWrappers(this.backends.values());
        if (null == innerBackends) {
            innerBackends = new ArrayList<BackendAddressPoolInner>();
        }
        ((LoadBalancerInner)((Object)this.innerModel())).withBackendAddressPools(innerBackends);
        ArrayList<FrontendIpConfigurationInner> innerFrontends = this.innersFromWrappers(this.frontends.values());
        if (null == innerFrontends) {
            innerFrontends = new ArrayList<FrontendIpConfigurationInner>();
        }
        ((LoadBalancerInner)((Object)this.innerModel())).withFrontendIpConfigurations(innerFrontends);
        ArrayList<InboundNatRuleInner> innerNatRules = this.innersFromWrappers(this.inboundNatRules.values());
        if (null == innerNatRules) {
            innerNatRules = new ArrayList<InboundNatRuleInner>();
        }
        ((LoadBalancerInner)((Object)this.innerModel())).withInboundNatRules(innerNatRules);
        for (LoadBalancerInboundNatRule loadBalancerInboundNatRule : this.inboundNatRules.values()) {
            SubResource ref = ((InboundNatRuleInner)((Object)loadBalancerInboundNatRule.innerModel())).frontendIpConfiguration();
            if (ref == null || this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((InboundNatRuleInner)((Object)loadBalancerInboundNatRule.innerModel())).withFrontendIpConfiguration(null);
        }
        ArrayList<InboundNatPool> innerNatPools = this.innersFromWrappers(this.inboundNatPools.values());
        if (null == innerNatPools) {
            innerNatPools = new ArrayList<InboundNatPool>();
        }
        ((LoadBalancerInner)((Object)this.innerModel())).withInboundNatPools(innerNatPools);
        for (LoadBalancerInboundNatPool natPool : this.inboundNatPools.values()) {
            SubResource ref = ((InboundNatPool)((Object)natPool.innerModel())).frontendIpConfiguration();
            if (ref == null || this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((InboundNatPool)((Object)natPool.innerModel())).withFrontendIpConfiguration(null);
        }
        List list = this.innersFromWrappers(this.loadBalancingRules.values());
        if (list == null) {
            ArrayList arrayList = new ArrayList();
        }
        ((LoadBalancerInner)((Object)this.innerModel())).withLoadBalancingRules((List<LoadBalancingRuleInner>)var6_10);
        for (LoadBalancingRule lbRule : this.loadBalancingRules.values()) {
            SubResource ref = ((LoadBalancingRuleInner)((Object)lbRule.innerModel())).frontendIpConfiguration();
            if (ref != null && !this.frontends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((LoadBalancingRuleInner)((Object)lbRule.innerModel())).withFrontendIpConfiguration(null);
            }
            if ((ref = ((LoadBalancingRuleInner)((Object)lbRule.innerModel())).backendAddressPool()) != null && !this.backends().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) {
                ((LoadBalancingRuleInner)((Object)lbRule.innerModel())).withBackendAddressPool(null);
            }
            if ((ref = ((LoadBalancingRuleInner)((Object)lbRule.innerModel())).probe()) == null || this.httpProbes().containsKey(ResourceUtils.nameFromResourceId((String)ref.id())) || this.httpsProbes().containsKey(ResourceUtils.nameFromResourceId((String)ref.id())) || this.tcpProbes().containsKey(ResourceUtils.nameFromResourceId((String)ref.id()))) continue;
            ((LoadBalancingRuleInner)((Object)lbRule.innerModel())).withProbe(null);
        }
    }

    protected Mono<Void> afterCreatingAsync() {
        if (this.nicsInBackends != null) {
            ArrayList nicExceptions = new ArrayList();
            return Flux.fromIterable(this.nicsInBackends.entrySet()).flatMap(nicInBackend -> {
                String nicId = (String)nicInBackend.getKey();
                String backendName = (String)nicInBackend.getValue();
                return ((NetworkManager)this.manager()).networkInterfaces().getByIdAsync(nicId).flatMap(nic -> {
                    NicIpConfiguration nicIP = nic.primaryIPConfiguration();
                    return ((NetworkInterface.Update)((NetworkInterface.Update)nic.update()).updateIPConfiguration(nicIP.name()).withExistingLoadBalancerBackend(this, backendName).parent()).applyAsync();
                });
            }).onErrorResume(t -> {
                nicExceptions.add(t);
                return Mono.empty();
            }).then(Mono.defer(() -> {
                if (!nicExceptions.isEmpty()) {
                    return Mono.error((Throwable)Exceptions.multiple((Iterable)nicExceptions));
                }
                this.nicsInBackends.clear();
                return Mono.empty();
            }));
        }
        return Mono.empty();
    }

    protected Mono<LoadBalancerInner> createInner() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getLoadBalancers().createOrUpdateAsync(this.resourceGroupName(), this.name(), (LoadBalancerInner)((Object)this.innerModel()));
    }

    public Mono<LoadBalancer> createResourceAsync() {
        this.beforeCreating();
        return this.createInner().flatMap(inner -> {
            this.setInner(inner);
            this.initializeChildrenFromInner();
            return this.afterCreatingAsync().then(this.refreshAsync());
        });
    }

    private void initializeFrontendsFromInner() {
        this.frontends = new TreeMap<String, LoadBalancerFrontend>();
        List<FrontendIpConfigurationInner> frontendsInner = ((LoadBalancerInner)((Object)this.innerModel())).frontendIpConfigurations();
        if (frontendsInner != null) {
            for (FrontendIpConfigurationInner frontendInner : frontendsInner) {
                LoadBalancerFrontendImpl frontend = new LoadBalancerFrontendImpl(frontendInner, this);
                this.frontends.put(frontendInner.name(), frontend);
            }
        }
    }

    private void initializeBackendsFromInner() {
        this.backends = new TreeMap<String, LoadBalancerBackend>();
        List<BackendAddressPoolInner> backendsInner = ((LoadBalancerInner)((Object)this.innerModel())).backendAddressPools();
        if (backendsInner != null) {
            for (BackendAddressPoolInner backendInner : backendsInner) {
                LoadBalancerBackendImpl backend = new LoadBalancerBackendImpl(backendInner, this);
                this.backends.put(backendInner.name(), backend);
            }
        }
    }

    private void initializeProbesFromInner() {
        this.httpProbes = new TreeMap<String, LoadBalancerHttpProbe>();
        this.httpsProbes = new TreeMap<String, LoadBalancerHttpProbe>();
        this.tcpProbes = new TreeMap<String, LoadBalancerTcpProbe>();
        if (((LoadBalancerInner)((Object)this.innerModel())).probes() != null) {
            for (ProbeInner probeInner : ((LoadBalancerInner)((Object)this.innerModel())).probes()) {
                LoadBalancerProbeImpl probe = new LoadBalancerProbeImpl(probeInner, this);
                if (probeInner.protocol().equals((Object)ProbeProtocol.TCP)) {
                    this.tcpProbes.put(probeInner.name(), probe);
                    continue;
                }
                if (probeInner.protocol().equals((Object)ProbeProtocol.HTTP)) {
                    this.httpProbes.put(probeInner.name(), probe);
                    continue;
                }
                if (!probeInner.protocol().equals((Object)ProbeProtocol.HTTPS)) continue;
                this.httpsProbes.put(probeInner.name(), probe);
            }
        }
    }

    private void initializeLoadBalancingRulesFromInner() {
        this.loadBalancingRules = new TreeMap<String, LoadBalancingRule>();
        List<LoadBalancingRuleInner> rulesInner = ((LoadBalancerInner)((Object)this.innerModel())).loadBalancingRules();
        if (rulesInner != null) {
            for (LoadBalancingRuleInner ruleInner : rulesInner) {
                LoadBalancingRuleImpl rule = new LoadBalancingRuleImpl(ruleInner, this);
                this.loadBalancingRules.put(ruleInner.name(), rule);
            }
        }
    }

    private void initializeInboundNatPoolsFromInner() {
        this.inboundNatPools = new TreeMap<String, LoadBalancerInboundNatPool>();
        List<InboundNatPool> inners = ((LoadBalancerInner)((Object)this.innerModel())).inboundNatPools();
        if (inners != null) {
            for (InboundNatPool inner : inners) {
                LoadBalancerInboundNatPoolImpl wrapper = new LoadBalancerInboundNatPoolImpl(inner, this);
                this.inboundNatPools.put(wrapper.name(), wrapper);
            }
        }
    }

    private void initializeInboundNatRulesFromInner() {
        this.inboundNatRules = new TreeMap<String, LoadBalancerInboundNatRule>();
        List<InboundNatRuleInner> rulesInner = ((LoadBalancerInner)((Object)this.innerModel())).inboundNatRules();
        if (rulesInner != null) {
            for (InboundNatRuleInner ruleInner : rulesInner) {
                LoadBalancerInboundNatRuleImpl rule = new LoadBalancerInboundNatRuleImpl(ruleInner, this);
                this.inboundNatRules.put(ruleInner.name(), rule);
            }
        }
    }

    String futureResourceId() {
        return super.resourceIdBase() + "/providers/Microsoft.Network/loadBalancers/" + this.name();
    }

    LoadBalancerImpl withFrontend(LoadBalancerFrontendImpl frontend) {
        if (frontend != null) {
            this.frontends.put(frontend.name(), frontend);
        }
        return this;
    }

    LoadBalancerImpl withProbe(LoadBalancerProbeImpl probe) {
        if (probe == null) {
            return this;
        }
        if (probe.protocol() == ProbeProtocol.HTTP) {
            this.httpProbes.put(probe.name(), probe);
        } else if (probe.protocol() == ProbeProtocol.HTTPS) {
            this.httpsProbes.put(probe.name(), probe);
        } else if (probe.protocol() == ProbeProtocol.TCP) {
            this.tcpProbes.put(probe.name(), probe);
        }
        return this;
    }

    LoadBalancerImpl withLoadBalancingRule(LoadBalancingRuleImpl loadBalancingRule) {
        if (loadBalancingRule != null) {
            this.loadBalancingRules.put(loadBalancingRule.name(), loadBalancingRule);
        }
        return this;
    }

    LoadBalancerImpl withInboundNatRule(LoadBalancerInboundNatRuleImpl inboundNatRule) {
        if (inboundNatRule != null) {
            this.inboundNatRules.put(inboundNatRule.name(), inboundNatRule);
        }
        return this;
    }

    LoadBalancerImpl withInboundNatPool(LoadBalancerInboundNatPoolImpl inboundNatPool) {
        if (inboundNatPool != null) {
            this.inboundNatPools.put(inboundNatPool.name(), inboundNatPool);
        }
        return this;
    }

    LoadBalancerImpl withBackend(LoadBalancerBackendImpl backend) {
        if (backend != null) {
            this.backends.put(backend.name(), backend);
        }
        return this;
    }

    LoadBalancerImpl withNewPublicIPAddress(String dnsLeafLabel, String frontendName) {
        PublicIpAddress.DefinitionStages.WithGroup precreatablePIP = (PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)((NetworkManager)this.manager()).publicIpAddresses().define(dnsLeafLabel)).withRegion(this.regionName());
        PublicIpAddress.DefinitionStages.WithCreate creatablePip = this.creatableGroup == null ? ((PublicIpAddress.DefinitionStages.WithCreate)precreatablePIP.withExistingResourceGroup(this.resourceGroupName())).withLeafDomainLabel(dnsLeafLabel) : ((PublicIpAddress.DefinitionStages.WithCreate)precreatablePIP.withNewResourceGroup(this.creatableGroup)).withLeafDomainLabel(dnsLeafLabel);
        return this.withNewPublicIPAddress(creatablePip, frontendName);
    }

    LoadBalancerImpl withNewPublicIPAddress(Creatable<PublicIpAddress> creatablePip, String frontendName) {
        String existingPipFrontendName = this.creatablePIPKeys.get(creatablePip.key());
        if (frontendName == null) {
            frontendName = existingPipFrontendName != null ? existingPipFrontendName : this.ensureUniqueFrontend().name();
        }
        if (existingPipFrontendName == null) {
            this.creatablePIPKeys.put(this.addDependency(creatablePip), frontendName);
        } else if (!existingPipFrontendName.equalsIgnoreCase(frontendName)) {
            String exceptionMessage = "This public IP address definition is already associated with a frontend under a different name.";
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(exceptionMessage));
        }
        return this;
    }

    protected LoadBalancerImpl withExistingPublicIPAddress(String resourceId, String frontendName) {
        if (frontendName == null) {
            return (LoadBalancerImpl)this.ensureUniqueFrontend().withExistingPublicIpAddress(resourceId).parent();
        }
        return this.definePublicFrontend(frontendName).withExistingPublicIpAddress(resourceId).attach();
    }

    LoadBalancerImpl withExistingVirtualMachine(HasNetworkInterfaces vm, String backendName) {
        if (backendName != null) {
            this.defineBackend(backendName).attach();
            if (vm.primaryNetworkInterfaceId() != null) {
                this.nicsInBackends.put(vm.primaryNetworkInterfaceId(), backendName.toLowerCase(Locale.ROOT));
            }
        }
        return this;
    }

    public LoadBalancerProbeImpl defineTcpProbe(String name) {
        LoadBalancerProbe probe = this.tcpProbes.get(name);
        if (probe == null) {
            ProbeInner inner = new ProbeInner().withName(name).withProtocol(ProbeProtocol.TCP);
            return new LoadBalancerProbeImpl(inner, this);
        }
        return (LoadBalancerProbeImpl)probe;
    }

    public LoadBalancerProbeImpl defineHttpProbe(String name) {
        LoadBalancerProbe probe = this.httpProbes.get(name);
        if (probe == null) {
            ProbeInner inner = new ProbeInner().withName(name).withProtocol(ProbeProtocol.HTTP).withPort(80);
            return new LoadBalancerProbeImpl(inner, this);
        }
        return (LoadBalancerProbeImpl)probe;
    }

    public LoadBalancerProbeImpl defineHttpsProbe(String name) {
        LoadBalancerProbe probe = this.httpsProbes.get(name);
        if (probe == null) {
            ProbeInner inner = new ProbeInner().withName(name).withProtocol(ProbeProtocol.HTTPS).withPort(443);
            return new LoadBalancerProbeImpl(inner, this);
        }
        return (LoadBalancerProbeImpl)probe;
    }

    public LoadBalancingRuleImpl defineLoadBalancingRule(String name) {
        LoadBalancingRule lbRule = this.loadBalancingRules.get(name);
        if (lbRule == null) {
            LoadBalancingRuleInner inner = new LoadBalancingRuleInner().withName(name);
            return new LoadBalancingRuleImpl(inner, this);
        }
        return (LoadBalancingRuleImpl)lbRule;
    }

    public LoadBalancerInboundNatRuleImpl defineInboundNatRule(String name) {
        LoadBalancerInboundNatRule natRule = this.inboundNatRules.get(name);
        if (natRule == null) {
            InboundNatRuleInner inner = new InboundNatRuleInner().withName(name);
            return new LoadBalancerInboundNatRuleImpl(inner, this);
        }
        return (LoadBalancerInboundNatRuleImpl)natRule;
    }

    public LoadBalancerInboundNatPoolImpl defineInboundNatPool(String name) {
        LoadBalancerInboundNatPool natPool = this.inboundNatPools.get(name);
        if (natPool == null) {
            InboundNatPool inner = new InboundNatPool().withName(name);
            return new LoadBalancerInboundNatPoolImpl(inner, this);
        }
        return (LoadBalancerInboundNatPoolImpl)natPool;
    }

    public LoadBalancerFrontendImpl definePrivateFrontend(String name) {
        return this.defineFrontend(name);
    }

    public LoadBalancerFrontendImpl definePublicFrontend(String name) {
        return this.defineFrontend(name);
    }

    LoadBalancerFrontendImpl defineFrontend(String name) {
        LoadBalancerFrontend frontend = this.frontends.get(name);
        if (frontend == null) {
            FrontendIpConfigurationInner inner = new FrontendIpConfigurationInner().withName(name);
            return new LoadBalancerFrontendImpl(inner, this);
        }
        return (LoadBalancerFrontendImpl)frontend;
    }

    public LoadBalancerBackendImpl defineBackend(String name) {
        LoadBalancerBackend backend = this.backends.get(name);
        if (backend == null) {
            BackendAddressPoolInner inner = new BackendAddressPoolInner().withName(name);
            return new LoadBalancerBackendImpl(inner, this);
        }
        return (LoadBalancerBackendImpl)backend;
    }

    @Override
    public LoadBalancerImpl withSku(LoadBalancerSkuType skuType) {
        ((LoadBalancerInner)((Object)this.innerModel())).withSku(skuType.sku());
        return this;
    }

    @Override
    public LoadBalancerImpl withoutProbe(String name) {
        if (this.httpProbes.containsKey(name)) {
            this.httpProbes.remove(name);
        } else if (this.httpsProbes.containsKey(name)) {
            this.httpsProbes.remove(name);
        } else if (this.tcpProbes.containsKey(name)) {
            this.tcpProbes.remove(name);
        }
        return this;
    }

    @Override
    public LoadBalancerProbeImpl updateTcpProbe(String name) {
        return (LoadBalancerProbeImpl)this.tcpProbes.get(name);
    }

    @Override
    public LoadBalancerBackendImpl updateBackend(String name) {
        return (LoadBalancerBackendImpl)this.backends.get(name);
    }

    @Override
    public LoadBalancerFrontendImpl updatePublicFrontend(String name) {
        return (LoadBalancerFrontendImpl)this.frontends.get(name);
    }

    @Override
    public LoadBalancerFrontendImpl updatePrivateFrontend(String name) {
        return (LoadBalancerFrontendImpl)this.frontends.get(name);
    }

    @Override
    public LoadBalancerInboundNatRuleImpl updateInboundNatRule(String name) {
        return (LoadBalancerInboundNatRuleImpl)this.inboundNatRules.get(name);
    }

    @Override
    public LoadBalancerInboundNatPoolImpl updateInboundNatPool(String name) {
        return (LoadBalancerInboundNatPoolImpl)this.inboundNatPools.get(name);
    }

    @Override
    public LoadBalancerProbeImpl updateHttpProbe(String name) {
        return (LoadBalancerProbeImpl)this.httpProbes.get(name);
    }

    @Override
    public LoadBalancerProbeImpl updateHttpsProbe(String name) {
        return (LoadBalancerProbeImpl)this.httpsProbes.get(name);
    }

    @Override
    public LoadBalancingRuleImpl updateLoadBalancingRule(String name) {
        return (LoadBalancingRuleImpl)this.loadBalancingRules.get(name);
    }

    @Override
    public LoadBalancerImpl withoutLoadBalancingRule(String name) {
        this.loadBalancingRules.remove(name);
        return this;
    }

    @Override
    public LoadBalancerImpl withoutInboundNatRule(String name) {
        this.inboundNatRules.remove(name);
        return this;
    }

    @Override
    public LoadBalancerImpl withoutBackend(String name) {
        this.backends.remove(name);
        return this;
    }

    @Override
    public LoadBalancer.Update withoutInboundNatPool(String name) {
        this.inboundNatPools.remove(name);
        return this;
    }

    @Override
    public LoadBalancerImpl withoutFrontend(String name) {
        this.frontends.remove(name);
        return this;
    }

    @Override
    public Map<String, LoadBalancerBackend> backends() {
        return Collections.unmodifiableMap(this.backends);
    }

    @Override
    public Map<String, LoadBalancerInboundNatPool> inboundNatPools() {
        return Collections.unmodifiableMap(this.inboundNatPools);
    }

    @Override
    public LoadBalancerSkuType sku() {
        return LoadBalancerSkuType.fromSku(((LoadBalancerInner)((Object)this.innerModel())).sku());
    }

    @Override
    public Map<String, LoadBalancerTcpProbe> tcpProbes() {
        return Collections.unmodifiableMap(this.tcpProbes);
    }

    @Override
    public Map<String, LoadBalancerFrontend> frontends() {
        return Collections.unmodifiableMap(this.frontends);
    }

    @Override
    public Map<String, LoadBalancerPrivateFrontend> privateFrontends() {
        HashMap<String, LoadBalancerPrivateFrontend> privateFrontends = new HashMap<String, LoadBalancerPrivateFrontend>();
        for (LoadBalancerFrontend frontend : this.frontends().values()) {
            if (frontend.isPublic()) continue;
            privateFrontends.put(frontend.name(), (LoadBalancerPrivateFrontend)frontend);
        }
        return Collections.unmodifiableMap(privateFrontends);
    }

    @Override
    public Map<String, LoadBalancerPublicFrontend> publicFrontends() {
        HashMap<String, LoadBalancerPublicFrontend> publicFrontends = new HashMap<String, LoadBalancerPublicFrontend>();
        for (LoadBalancerFrontend frontend : this.frontends().values()) {
            if (!frontend.isPublic()) continue;
            publicFrontends.put(frontend.name(), (LoadBalancerPublicFrontend)frontend);
        }
        return Collections.unmodifiableMap(publicFrontends);
    }

    @Override
    public Map<String, LoadBalancerInboundNatRule> inboundNatRules() {
        return Collections.unmodifiableMap(this.inboundNatRules);
    }

    @Override
    public Map<String, LoadBalancerHttpProbe> httpProbes() {
        return Collections.unmodifiableMap(this.httpProbes);
    }

    @Override
    public Map<String, LoadBalancerHttpProbe> httpsProbes() {
        return Collections.unmodifiableMap(this.httpsProbes);
    }

    @Override
    public Map<String, LoadBalancingRule> loadBalancingRules() {
        return Collections.unmodifiableMap(this.loadBalancingRules);
    }

    @Override
    public List<String> publicIpAddressIds() {
        ArrayList<String> publicIPAddressIds = new ArrayList<String>();
        for (LoadBalancerFrontend frontend : this.frontends().values()) {
            if (!frontend.isPublic()) continue;
            String pipId = ((LoadBalancerPublicFrontend)frontend).publicIpAddressId();
            publicIPAddressIds.add(pipId);
        }
        return Collections.unmodifiableList(publicIPAddressIds);
    }

    @Override
    public LoadBalancerPublicFrontend findFrontendByPublicIpAddress(String pipId) {
        if (pipId == null) {
            return null;
        }
        for (LoadBalancerPublicFrontend frontend : this.publicFrontends().values()) {
            if (frontend.publicIpAddressId() == null || !pipId.equalsIgnoreCase(frontend.publicIpAddressId())) continue;
            return frontend;
        }
        return null;
    }

    @Override
    public LoadBalancerPublicFrontend findFrontendByPublicIpAddress(PublicIpAddress publicIPAddress) {
        return publicIPAddress != null ? this.findFrontendByPublicIpAddress(publicIPAddress.id()) : null;
    }
}

