/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualNetworkBgpCommunities;
import com.azure.resourcemanager.network.models.VirtualNetworkPeeringLevel;
import com.azure.resourcemanager.network.models.VirtualNetworkPeeringState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class VirtualNetworkPeeringInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualNetworkPeeringInner.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="properties.allowVirtualNetworkAccess")
    private Boolean allowVirtualNetworkAccess;
    @JsonProperty(value="properties.allowForwardedTraffic")
    private Boolean allowForwardedTraffic;
    @JsonProperty(value="properties.allowGatewayTransit")
    private Boolean allowGatewayTransit;
    @JsonProperty(value="properties.useRemoteGateways")
    private Boolean useRemoteGateways;
    @JsonProperty(value="properties.remoteVirtualNetwork")
    private SubResource remoteVirtualNetwork;
    @JsonProperty(value="properties.remoteAddressSpace")
    private AddressSpace remoteAddressSpace;
    @JsonProperty(value="properties.remoteVirtualNetworkAddressSpace")
    private AddressSpace remoteVirtualNetworkAddressSpace;
    @JsonProperty(value="properties.remoteBgpCommunities")
    private VirtualNetworkBgpCommunities remoteBgpCommunities;
    @JsonProperty(value="properties.peeringState")
    private VirtualNetworkPeeringState peeringState;
    @JsonProperty(value="properties.peeringSyncLevel")
    private VirtualNetworkPeeringLevel peeringSyncLevel;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.doNotVerifyRemoteGateways")
    private Boolean doNotVerifyRemoteGateways;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;

    public String name() {
        return this.name;
    }

    public VirtualNetworkPeeringInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public VirtualNetworkPeeringInner withType(String type) {
        this.type = type;
        return this;
    }

    public Boolean allowVirtualNetworkAccess() {
        return this.allowVirtualNetworkAccess;
    }

    public VirtualNetworkPeeringInner withAllowVirtualNetworkAccess(Boolean allowVirtualNetworkAccess) {
        this.allowVirtualNetworkAccess = allowVirtualNetworkAccess;
        return this;
    }

    public Boolean allowForwardedTraffic() {
        return this.allowForwardedTraffic;
    }

    public VirtualNetworkPeeringInner withAllowForwardedTraffic(Boolean allowForwardedTraffic) {
        this.allowForwardedTraffic = allowForwardedTraffic;
        return this;
    }

    public Boolean allowGatewayTransit() {
        return this.allowGatewayTransit;
    }

    public VirtualNetworkPeeringInner withAllowGatewayTransit(Boolean allowGatewayTransit) {
        this.allowGatewayTransit = allowGatewayTransit;
        return this;
    }

    public Boolean useRemoteGateways() {
        return this.useRemoteGateways;
    }

    public VirtualNetworkPeeringInner withUseRemoteGateways(Boolean useRemoteGateways) {
        this.useRemoteGateways = useRemoteGateways;
        return this;
    }

    public SubResource remoteVirtualNetwork() {
        return this.remoteVirtualNetwork;
    }

    public VirtualNetworkPeeringInner withRemoteVirtualNetwork(SubResource remoteVirtualNetwork) {
        this.remoteVirtualNetwork = remoteVirtualNetwork;
        return this;
    }

    public AddressSpace remoteAddressSpace() {
        return this.remoteAddressSpace;
    }

    public VirtualNetworkPeeringInner withRemoteAddressSpace(AddressSpace remoteAddressSpace) {
        this.remoteAddressSpace = remoteAddressSpace;
        return this;
    }

    public AddressSpace remoteVirtualNetworkAddressSpace() {
        return this.remoteVirtualNetworkAddressSpace;
    }

    public VirtualNetworkPeeringInner withRemoteVirtualNetworkAddressSpace(AddressSpace remoteVirtualNetworkAddressSpace) {
        this.remoteVirtualNetworkAddressSpace = remoteVirtualNetworkAddressSpace;
        return this;
    }

    public VirtualNetworkBgpCommunities remoteBgpCommunities() {
        return this.remoteBgpCommunities;
    }

    public VirtualNetworkPeeringInner withRemoteBgpCommunities(VirtualNetworkBgpCommunities remoteBgpCommunities) {
        this.remoteBgpCommunities = remoteBgpCommunities;
        return this;
    }

    public VirtualNetworkPeeringState peeringState() {
        return this.peeringState;
    }

    public VirtualNetworkPeeringInner withPeeringState(VirtualNetworkPeeringState peeringState) {
        this.peeringState = peeringState;
        return this;
    }

    public VirtualNetworkPeeringLevel peeringSyncLevel() {
        return this.peeringSyncLevel;
    }

    public VirtualNetworkPeeringInner withPeeringSyncLevel(VirtualNetworkPeeringLevel peeringSyncLevel) {
        this.peeringSyncLevel = peeringSyncLevel;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean doNotVerifyRemoteGateways() {
        return this.doNotVerifyRemoteGateways;
    }

    public VirtualNetworkPeeringInner withDoNotVerifyRemoteGateways(Boolean doNotVerifyRemoteGateways) {
        this.doNotVerifyRemoteGateways = doNotVerifyRemoteGateways;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public VirtualNetworkPeeringInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.remoteAddressSpace() != null) {
            this.remoteAddressSpace().validate();
        }
        if (this.remoteVirtualNetworkAddressSpace() != null) {
            this.remoteVirtualNetworkAddressSpace().validate();
        }
        if (this.remoteBgpCommunities() != null) {
            this.remoteBgpCommunities().validate();
        }
    }
}

