/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.LocalNetworkGatewayInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayInner;
import com.azure.resourcemanager.network.models.IpsecPolicy;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TrafficSelectorPolicy;
import com.azure.resourcemanager.network.models.TunnelConnectionHealth;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionMode;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionProtocol;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionStatus;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayConnectionType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualNetworkGatewayConnectionInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualNetworkGatewayConnectionInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.authorizationKey")
    private String authorizationKey;
    @JsonProperty(value="properties.virtualNetworkGateway1", required=true)
    private VirtualNetworkGatewayInner virtualNetworkGateway1;
    @JsonProperty(value="properties.virtualNetworkGateway2")
    private VirtualNetworkGatewayInner virtualNetworkGateway2;
    @JsonProperty(value="properties.localNetworkGateway2")
    private LocalNetworkGatewayInner localNetworkGateway2;
    @JsonProperty(value="properties.ingressNatRules")
    private List<SubResource> ingressNatRules;
    @JsonProperty(value="properties.egressNatRules")
    private List<SubResource> egressNatRules;
    @JsonProperty(value="properties.connectionType", required=true)
    private VirtualNetworkGatewayConnectionType connectionType;
    @JsonProperty(value="properties.connectionProtocol")
    private VirtualNetworkGatewayConnectionProtocol connectionProtocol;
    @JsonProperty(value="properties.routingWeight")
    private Integer routingWeight;
    @JsonProperty(value="properties.dpdTimeoutSeconds")
    private Integer dpdTimeoutSeconds;
    @JsonProperty(value="properties.connectionMode")
    private VirtualNetworkGatewayConnectionMode connectionMode;
    @JsonProperty(value="properties.sharedKey")
    private String sharedKey;
    @JsonProperty(value="properties.connectionStatus", access=JsonProperty.Access.WRITE_ONLY)
    private VirtualNetworkGatewayConnectionStatus connectionStatus;
    @JsonProperty(value="properties.tunnelConnectionStatus", access=JsonProperty.Access.WRITE_ONLY)
    private List<TunnelConnectionHealth> tunnelConnectionStatus;
    @JsonProperty(value="properties.egressBytesTransferred", access=JsonProperty.Access.WRITE_ONLY)
    private Long egressBytesTransferred;
    @JsonProperty(value="properties.ingressBytesTransferred", access=JsonProperty.Access.WRITE_ONLY)
    private Long ingressBytesTransferred;
    @JsonProperty(value="properties.peer")
    private SubResource peer;
    @JsonProperty(value="properties.enableBgp")
    private Boolean enableBgp;
    @JsonProperty(value="properties.useLocalAzureIpAddress")
    private Boolean useLocalAzureIpAddress;
    @JsonProperty(value="properties.usePolicyBasedTrafficSelectors")
    private Boolean usePolicyBasedTrafficSelectors;
    @JsonProperty(value="properties.ipsecPolicies")
    private List<IpsecPolicy> ipsecPolicies;
    @JsonProperty(value="properties.trafficSelectorPolicies")
    private List<TrafficSelectorPolicy> trafficSelectorPolicies;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.expressRouteGatewayBypass")
    private Boolean expressRouteGatewayBypass;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public String authorizationKey() {
        return this.authorizationKey;
    }

    public VirtualNetworkGatewayConnectionInner withAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    public VirtualNetworkGatewayInner virtualNetworkGateway1() {
        return this.virtualNetworkGateway1;
    }

    public VirtualNetworkGatewayConnectionInner withVirtualNetworkGateway1(VirtualNetworkGatewayInner virtualNetworkGateway1) {
        this.virtualNetworkGateway1 = virtualNetworkGateway1;
        return this;
    }

    public VirtualNetworkGatewayInner virtualNetworkGateway2() {
        return this.virtualNetworkGateway2;
    }

    public VirtualNetworkGatewayConnectionInner withVirtualNetworkGateway2(VirtualNetworkGatewayInner virtualNetworkGateway2) {
        this.virtualNetworkGateway2 = virtualNetworkGateway2;
        return this;
    }

    public LocalNetworkGatewayInner localNetworkGateway2() {
        return this.localNetworkGateway2;
    }

    public VirtualNetworkGatewayConnectionInner withLocalNetworkGateway2(LocalNetworkGatewayInner localNetworkGateway2) {
        this.localNetworkGateway2 = localNetworkGateway2;
        return this;
    }

    public List<SubResource> ingressNatRules() {
        return this.ingressNatRules;
    }

    public VirtualNetworkGatewayConnectionInner withIngressNatRules(List<SubResource> ingressNatRules) {
        this.ingressNatRules = ingressNatRules;
        return this;
    }

    public List<SubResource> egressNatRules() {
        return this.egressNatRules;
    }

    public VirtualNetworkGatewayConnectionInner withEgressNatRules(List<SubResource> egressNatRules) {
        this.egressNatRules = egressNatRules;
        return this;
    }

    public VirtualNetworkGatewayConnectionType connectionType() {
        return this.connectionType;
    }

    public VirtualNetworkGatewayConnectionInner withConnectionType(VirtualNetworkGatewayConnectionType connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    public VirtualNetworkGatewayConnectionProtocol connectionProtocol() {
        return this.connectionProtocol;
    }

    public VirtualNetworkGatewayConnectionInner withConnectionProtocol(VirtualNetworkGatewayConnectionProtocol connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public Integer routingWeight() {
        return this.routingWeight;
    }

    public VirtualNetworkGatewayConnectionInner withRoutingWeight(Integer routingWeight) {
        this.routingWeight = routingWeight;
        return this;
    }

    public Integer dpdTimeoutSeconds() {
        return this.dpdTimeoutSeconds;
    }

    public VirtualNetworkGatewayConnectionInner withDpdTimeoutSeconds(Integer dpdTimeoutSeconds) {
        this.dpdTimeoutSeconds = dpdTimeoutSeconds;
        return this;
    }

    public VirtualNetworkGatewayConnectionMode connectionMode() {
        return this.connectionMode;
    }

    public VirtualNetworkGatewayConnectionInner withConnectionMode(VirtualNetworkGatewayConnectionMode connectionMode) {
        this.connectionMode = connectionMode;
        return this;
    }

    public String sharedKey() {
        return this.sharedKey;
    }

    public VirtualNetworkGatewayConnectionInner withSharedKey(String sharedKey) {
        this.sharedKey = sharedKey;
        return this;
    }

    public VirtualNetworkGatewayConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public List<TunnelConnectionHealth> tunnelConnectionStatus() {
        return this.tunnelConnectionStatus;
    }

    public Long egressBytesTransferred() {
        return this.egressBytesTransferred;
    }

    public Long ingressBytesTransferred() {
        return this.ingressBytesTransferred;
    }

    public SubResource peer() {
        return this.peer;
    }

    public VirtualNetworkGatewayConnectionInner withPeer(SubResource peer) {
        this.peer = peer;
        return this;
    }

    public Boolean enableBgp() {
        return this.enableBgp;
    }

    public VirtualNetworkGatewayConnectionInner withEnableBgp(Boolean enableBgp) {
        this.enableBgp = enableBgp;
        return this;
    }

    public Boolean useLocalAzureIpAddress() {
        return this.useLocalAzureIpAddress;
    }

    public VirtualNetworkGatewayConnectionInner withUseLocalAzureIpAddress(Boolean useLocalAzureIpAddress) {
        this.useLocalAzureIpAddress = useLocalAzureIpAddress;
        return this;
    }

    public Boolean usePolicyBasedTrafficSelectors() {
        return this.usePolicyBasedTrafficSelectors;
    }

    public VirtualNetworkGatewayConnectionInner withUsePolicyBasedTrafficSelectors(Boolean usePolicyBasedTrafficSelectors) {
        this.usePolicyBasedTrafficSelectors = usePolicyBasedTrafficSelectors;
        return this;
    }

    public List<IpsecPolicy> ipsecPolicies() {
        return this.ipsecPolicies;
    }

    public VirtualNetworkGatewayConnectionInner withIpsecPolicies(List<IpsecPolicy> ipsecPolicies) {
        this.ipsecPolicies = ipsecPolicies;
        return this;
    }

    public List<TrafficSelectorPolicy> trafficSelectorPolicies() {
        return this.trafficSelectorPolicies;
    }

    public VirtualNetworkGatewayConnectionInner withTrafficSelectorPolicies(List<TrafficSelectorPolicy> trafficSelectorPolicies) {
        this.trafficSelectorPolicies = trafficSelectorPolicies;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean expressRouteGatewayBypass() {
        return this.expressRouteGatewayBypass;
    }

    public VirtualNetworkGatewayConnectionInner withExpressRouteGatewayBypass(Boolean expressRouteGatewayBypass) {
        this.expressRouteGatewayBypass = expressRouteGatewayBypass;
        return this;
    }

    public String id() {
        return this.id;
    }

    public VirtualNetworkGatewayConnectionInner withId(String id) {
        this.id = id;
        return this;
    }

    public VirtualNetworkGatewayConnectionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualNetworkGatewayConnectionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.virtualNetworkGateway1() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property virtualNetworkGateway1 in model VirtualNetworkGatewayConnectionInner"));
        }
        this.virtualNetworkGateway1().validate();
        if (this.virtualNetworkGateway2() != null) {
            this.virtualNetworkGateway2().validate();
        }
        if (this.localNetworkGateway2() != null) {
            this.localNetworkGateway2().validate();
        }
        if (this.connectionType() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property connectionType in model VirtualNetworkGatewayConnectionInner"));
        }
        if (this.tunnelConnectionStatus() != null) {
            this.tunnelConnectionStatus().forEach(e -> e.validate());
        }
        if (this.ipsecPolicies() != null) {
            this.ipsecPolicies().forEach(e -> e.validate());
        }
        if (this.trafficSelectorPolicies() != null) {
            this.trafficSelectorPolicies().forEach(e -> e.validate());
        }
    }
}

