/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.VirtualHubRouteTableV2Inner;
import com.azure.resourcemanager.network.models.PreferredRoutingGateway;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingState;
import com.azure.resourcemanager.network.models.VirtualHubRouteTable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualHubInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualHubInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.virtualWan")
    private SubResource virtualWan;
    @JsonProperty(value="properties.vpnGateway")
    private SubResource vpnGateway;
    @JsonProperty(value="properties.p2SVpnGateway")
    private SubResource p2SVpnGateway;
    @JsonProperty(value="properties.expressRouteGateway")
    private SubResource expressRouteGateway;
    @JsonProperty(value="properties.azureFirewall")
    private SubResource azureFirewall;
    @JsonProperty(value="properties.securityPartnerProvider")
    private SubResource securityPartnerProvider;
    @JsonProperty(value="properties.addressPrefix")
    private String addressPrefix;
    @JsonProperty(value="properties.routeTable")
    private VirtualHubRouteTable routeTable;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="properties.securityProviderName")
    private String securityProviderName;
    @JsonProperty(value="properties.virtualHubRouteTableV2s")
    private List<VirtualHubRouteTableV2Inner> virtualHubRouteTableV2S;
    @JsonProperty(value="properties.sku")
    private String sku;
    @JsonProperty(value="properties.routingState", access=JsonProperty.Access.WRITE_ONLY)
    private RoutingState routingState;
    @JsonProperty(value="properties.bgpConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> bgpConnections;
    @JsonProperty(value="properties.ipConfigurations", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> ipConfigurations;
    @JsonProperty(value="properties.virtualRouterAsn")
    private Long virtualRouterAsn;
    @JsonProperty(value="properties.virtualRouterIps")
    private List<String> virtualRouterIps;
    @JsonProperty(value="properties.allowBranchToBranchTraffic")
    private Boolean allowBranchToBranchTraffic;
    @JsonProperty(value="properties.preferredRoutingGateway")
    private PreferredRoutingGateway preferredRoutingGateway;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public SubResource virtualWan() {
        return this.virtualWan;
    }

    public VirtualHubInner withVirtualWan(SubResource virtualWan) {
        this.virtualWan = virtualWan;
        return this;
    }

    public SubResource vpnGateway() {
        return this.vpnGateway;
    }

    public VirtualHubInner withVpnGateway(SubResource vpnGateway) {
        this.vpnGateway = vpnGateway;
        return this;
    }

    public SubResource p2SVpnGateway() {
        return this.p2SVpnGateway;
    }

    public VirtualHubInner withP2SVpnGateway(SubResource p2SVpnGateway) {
        this.p2SVpnGateway = p2SVpnGateway;
        return this;
    }

    public SubResource expressRouteGateway() {
        return this.expressRouteGateway;
    }

    public VirtualHubInner withExpressRouteGateway(SubResource expressRouteGateway) {
        this.expressRouteGateway = expressRouteGateway;
        return this;
    }

    public SubResource azureFirewall() {
        return this.azureFirewall;
    }

    public VirtualHubInner withAzureFirewall(SubResource azureFirewall) {
        this.azureFirewall = azureFirewall;
        return this;
    }

    public SubResource securityPartnerProvider() {
        return this.securityPartnerProvider;
    }

    public VirtualHubInner withSecurityPartnerProvider(SubResource securityPartnerProvider) {
        this.securityPartnerProvider = securityPartnerProvider;
        return this;
    }

    public String addressPrefix() {
        return this.addressPrefix;
    }

    public VirtualHubInner withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    public VirtualHubRouteTable routeTable() {
        return this.routeTable;
    }

    public VirtualHubInner withRouteTable(VirtualHubRouteTable routeTable) {
        this.routeTable = routeTable;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String securityProviderName() {
        return this.securityProviderName;
    }

    public VirtualHubInner withSecurityProviderName(String securityProviderName) {
        this.securityProviderName = securityProviderName;
        return this;
    }

    public List<VirtualHubRouteTableV2Inner> virtualHubRouteTableV2S() {
        return this.virtualHubRouteTableV2S;
    }

    public VirtualHubInner withVirtualHubRouteTableV2S(List<VirtualHubRouteTableV2Inner> virtualHubRouteTableV2S) {
        this.virtualHubRouteTableV2S = virtualHubRouteTableV2S;
        return this;
    }

    public String sku() {
        return this.sku;
    }

    public VirtualHubInner withSku(String sku) {
        this.sku = sku;
        return this;
    }

    public RoutingState routingState() {
        return this.routingState;
    }

    public List<SubResource> bgpConnections() {
        return this.bgpConnections;
    }

    public List<SubResource> ipConfigurations() {
        return this.ipConfigurations;
    }

    public Long virtualRouterAsn() {
        return this.virtualRouterAsn;
    }

    public VirtualHubInner withVirtualRouterAsn(Long virtualRouterAsn) {
        this.virtualRouterAsn = virtualRouterAsn;
        return this;
    }

    public List<String> virtualRouterIps() {
        return this.virtualRouterIps;
    }

    public VirtualHubInner withVirtualRouterIps(List<String> virtualRouterIps) {
        this.virtualRouterIps = virtualRouterIps;
        return this;
    }

    public Boolean allowBranchToBranchTraffic() {
        return this.allowBranchToBranchTraffic;
    }

    public VirtualHubInner withAllowBranchToBranchTraffic(Boolean allowBranchToBranchTraffic) {
        this.allowBranchToBranchTraffic = allowBranchToBranchTraffic;
        return this;
    }

    public PreferredRoutingGateway preferredRoutingGateway() {
        return this.preferredRoutingGateway;
    }

    public VirtualHubInner withPreferredRoutingGateway(PreferredRoutingGateway preferredRoutingGateway) {
        this.preferredRoutingGateway = preferredRoutingGateway;
        return this;
    }

    public String id() {
        return this.id;
    }

    public VirtualHubInner withId(String id) {
        this.id = id;
        return this;
    }

    public VirtualHubInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualHubInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.routeTable() != null) {
            this.routeTable().validate();
        }
        if (this.virtualHubRouteTableV2S() != null) {
            this.virtualHubRouteTableV2S().forEach(e -> e.validate());
        }
    }
}

