/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityRuleAccess;
import com.azure.resourcemanager.network.models.SecurityRuleDirection;
import com.azure.resourcemanager.network.models.SecurityRuleProtocol;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class SecurityRuleInner
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SecurityRuleInner.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="properties.description")
    private String description;
    @JsonProperty(value="properties.protocol")
    private SecurityRuleProtocol protocol;
    @JsonProperty(value="properties.sourcePortRange")
    private String sourcePortRange;
    @JsonProperty(value="properties.destinationPortRange")
    private String destinationPortRange;
    @JsonProperty(value="properties.sourceAddressPrefix")
    private String sourceAddressPrefix;
    @JsonProperty(value="properties.sourceAddressPrefixes")
    private List<String> sourceAddressPrefixes;
    @JsonProperty(value="properties.sourceApplicationSecurityGroups")
    private List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups;
    @JsonProperty(value="properties.destinationAddressPrefix")
    private String destinationAddressPrefix;
    @JsonProperty(value="properties.destinationAddressPrefixes")
    private List<String> destinationAddressPrefixes;
    @JsonProperty(value="properties.destinationApplicationSecurityGroups")
    private List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups;
    @JsonProperty(value="properties.sourcePortRanges")
    private List<String> sourcePortRanges;
    @JsonProperty(value="properties.destinationPortRanges")
    private List<String> destinationPortRanges;
    @JsonProperty(value="properties.access")
    private SecurityRuleAccess access;
    @JsonProperty(value="properties.priority")
    private Integer priority;
    @JsonProperty(value="properties.direction")
    private SecurityRuleDirection direction;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public String name() {
        return this.name;
    }

    public SecurityRuleInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public SecurityRuleInner withType(String type) {
        this.type = type;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SecurityRuleInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public SecurityRuleProtocol protocol() {
        return this.protocol;
    }

    public SecurityRuleInner withProtocol(SecurityRuleProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String sourcePortRange() {
        return this.sourcePortRange;
    }

    public SecurityRuleInner withSourcePortRange(String sourcePortRange) {
        this.sourcePortRange = sourcePortRange;
        return this;
    }

    public String destinationPortRange() {
        return this.destinationPortRange;
    }

    public SecurityRuleInner withDestinationPortRange(String destinationPortRange) {
        this.destinationPortRange = destinationPortRange;
        return this;
    }

    public String sourceAddressPrefix() {
        return this.sourceAddressPrefix;
    }

    public SecurityRuleInner withSourceAddressPrefix(String sourceAddressPrefix) {
        this.sourceAddressPrefix = sourceAddressPrefix;
        return this;
    }

    public List<String> sourceAddressPrefixes() {
        return this.sourceAddressPrefixes;
    }

    public SecurityRuleInner withSourceAddressPrefixes(List<String> sourceAddressPrefixes) {
        this.sourceAddressPrefixes = sourceAddressPrefixes;
        return this;
    }

    public List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups() {
        return this.sourceApplicationSecurityGroups;
    }

    public SecurityRuleInner withSourceApplicationSecurityGroups(List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups) {
        this.sourceApplicationSecurityGroups = sourceApplicationSecurityGroups;
        return this;
    }

    public String destinationAddressPrefix() {
        return this.destinationAddressPrefix;
    }

    public SecurityRuleInner withDestinationAddressPrefix(String destinationAddressPrefix) {
        this.destinationAddressPrefix = destinationAddressPrefix;
        return this;
    }

    public List<String> destinationAddressPrefixes() {
        return this.destinationAddressPrefixes;
    }

    public SecurityRuleInner withDestinationAddressPrefixes(List<String> destinationAddressPrefixes) {
        this.destinationAddressPrefixes = destinationAddressPrefixes;
        return this;
    }

    public List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups() {
        return this.destinationApplicationSecurityGroups;
    }

    public SecurityRuleInner withDestinationApplicationSecurityGroups(List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups) {
        this.destinationApplicationSecurityGroups = destinationApplicationSecurityGroups;
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public SecurityRuleInner withSourcePortRanges(List<String> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public List<String> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public SecurityRuleInner withDestinationPortRanges(List<String> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    public SecurityRuleAccess access() {
        return this.access;
    }

    public SecurityRuleInner withAccess(SecurityRuleAccess access) {
        this.access = access;
        return this;
    }

    public Integer priority() {
        return this.priority;
    }

    public SecurityRuleInner withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public SecurityRuleDirection direction() {
        return this.direction;
    }

    public SecurityRuleInner withDirection(SecurityRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SecurityRuleInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.sourceApplicationSecurityGroups() != null) {
            this.sourceApplicationSecurityGroups().forEach(e -> e.validate());
        }
        if (this.destinationApplicationSecurityGroups() != null) {
            this.destinationApplicationSecurityGroups().forEach(e -> e.validate());
        }
    }
}

