/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.models.ProtocolType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.QosIpRange;
import com.azure.resourcemanager.network.models.QosPortRange;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class DscpConfigurationInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DscpConfigurationInner.class);
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="properties.markings")
    private List<Integer> markings;
    @JsonProperty(value="properties.sourceIpRanges")
    private List<QosIpRange> sourceIpRanges;
    @JsonProperty(value="properties.destinationIpRanges")
    private List<QosIpRange> destinationIpRanges;
    @JsonProperty(value="properties.sourcePortRanges")
    private List<QosPortRange> sourcePortRanges;
    @JsonProperty(value="properties.destinationPortRanges")
    private List<QosPortRange> destinationPortRanges;
    @JsonProperty(value="properties.protocol")
    private ProtocolType protocol;
    @JsonProperty(value="properties.qosCollectionId", access=JsonProperty.Access.WRITE_ONLY)
    private String qosCollectionId;
    @JsonProperty(value="properties.associatedNetworkInterfaces", access=JsonProperty.Access.WRITE_ONLY)
    private List<NetworkInterfaceInner> associatedNetworkInterfaces;
    @JsonProperty(value="properties.resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="id")
    private String id;

    public String etag() {
        return this.etag;
    }

    public List<Integer> markings() {
        return this.markings;
    }

    public DscpConfigurationInner withMarkings(List<Integer> markings) {
        this.markings = markings;
        return this;
    }

    public List<QosIpRange> sourceIpRanges() {
        return this.sourceIpRanges;
    }

    public DscpConfigurationInner withSourceIpRanges(List<QosIpRange> sourceIpRanges) {
        this.sourceIpRanges = sourceIpRanges;
        return this;
    }

    public List<QosIpRange> destinationIpRanges() {
        return this.destinationIpRanges;
    }

    public DscpConfigurationInner withDestinationIpRanges(List<QosIpRange> destinationIpRanges) {
        this.destinationIpRanges = destinationIpRanges;
        return this;
    }

    public List<QosPortRange> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public DscpConfigurationInner withSourcePortRanges(List<QosPortRange> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public List<QosPortRange> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public DscpConfigurationInner withDestinationPortRanges(List<QosPortRange> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    public ProtocolType protocol() {
        return this.protocol;
    }

    public DscpConfigurationInner withProtocol(ProtocolType protocol) {
        this.protocol = protocol;
        return this;
    }

    public String qosCollectionId() {
        return this.qosCollectionId;
    }

    public List<NetworkInterfaceInner> associatedNetworkInterfaces() {
        return this.associatedNetworkInterfaces;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String id() {
        return this.id;
    }

    public DscpConfigurationInner withId(String id) {
        this.id = id;
        return this;
    }

    public DscpConfigurationInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DscpConfigurationInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sourceIpRanges() != null) {
            this.sourceIpRanges().forEach(e -> e.validate());
        }
        if (this.destinationIpRanges() != null) {
            this.destinationIpRanges().forEach(e -> e.validate());
        }
        if (this.sourcePortRanges() != null) {
            this.sourcePortRanges().forEach(e -> e.validate());
        }
        if (this.destinationPortRanges() != null) {
            this.destinationPortRanges().forEach(e -> e.validate());
        }
        if (this.associatedNetworkInterfaces() != null) {
            this.associatedNetworkInterfaces().forEach(e -> e.validate());
        }
    }
}

