/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.DdosDetectionMode;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TrafficDetectionRule;
import java.io.IOException;

public final class DdosDetectionRulePropertiesFormat
implements JsonSerializable<DdosDetectionRulePropertiesFormat> {
    private ProvisioningState provisioningState;
    private DdosDetectionMode detectionMode;
    private TrafficDetectionRule trafficDetectionRule;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DdosDetectionMode detectionMode() {
        return this.detectionMode;
    }

    public DdosDetectionRulePropertiesFormat withDetectionMode(DdosDetectionMode detectionMode) {
        this.detectionMode = detectionMode;
        return this;
    }

    public TrafficDetectionRule trafficDetectionRule() {
        return this.trafficDetectionRule;
    }

    public DdosDetectionRulePropertiesFormat withTrafficDetectionRule(TrafficDetectionRule trafficDetectionRule) {
        this.trafficDetectionRule = trafficDetectionRule;
        return this;
    }

    public void validate() {
        if (this.trafficDetectionRule() != null) {
            this.trafficDetectionRule().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("detectionMode", this.detectionMode == null ? null : this.detectionMode.toString());
        jsonWriter.writeJsonField("trafficDetectionRule", (JsonSerializable)this.trafficDetectionRule);
        return jsonWriter.writeEndObject();
    }

    public static DdosDetectionRulePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (DdosDetectionRulePropertiesFormat)jsonReader.readObject(reader -> {
            DdosDetectionRulePropertiesFormat deserializedDdosDetectionRulePropertiesFormat = new DdosDetectionRulePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedDdosDetectionRulePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("detectionMode".equals(fieldName)) {
                    deserializedDdosDetectionRulePropertiesFormat.detectionMode = DdosDetectionMode.fromString(reader.getString());
                    continue;
                }
                if ("trafficDetectionRule".equals(fieldName)) {
                    deserializedDdosDetectionRulePropertiesFormat.trafficDetectionRule = TrafficDetectionRule.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDdosDetectionRulePropertiesFormat;
        });
    }
}

