/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.ExpressRouteCircuitPeeringsClient;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitPeeringInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.ExpressRouteCircuitPeeringListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ExpressRouteCircuitPeeringsClientImpl
implements ExpressRouteCircuitPeeringsClient {
    private final ExpressRouteCircuitPeeringsService service;
    private final NetworkManagementClientImpl client;

    ExpressRouteCircuitPeeringsClientImpl(NetworkManagementClientImpl client) {
        this.service = (ExpressRouteCircuitPeeringsService)RestProxy.create(ExpressRouteCircuitPeeringsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String circuitName, String peeringName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (circuitName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter circuitName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, circuitName, peeringName, "2025-01-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String circuitName, String peeringName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (circuitName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter circuitName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, circuitName, peeringName, "2025-01-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String circuitName, String peeringName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, circuitName, peeringName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String circuitName, String peeringName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, circuitName, peeringName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String circuitName, String peeringName) {
        return this.beginDeleteAsync(resourceGroupName, circuitName, peeringName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String circuitName, String peeringName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, circuitName, peeringName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String circuitName, String peeringName) {
        return this.beginDeleteAsync(resourceGroupName, circuitName, peeringName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String circuitName, String peeringName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, circuitName, peeringName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String circuitName, String peeringName) {
        this.deleteAsync(resourceGroupName, circuitName, peeringName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String circuitName, String peeringName, Context context) {
        this.deleteAsync(resourceGroupName, circuitName, peeringName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ExpressRouteCircuitPeeringInner>> getWithResponseAsync(String resourceGroupName, String circuitName, String peeringName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (circuitName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter circuitName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, circuitName, peeringName, "2025-01-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExpressRouteCircuitPeeringInner>> getWithResponseAsync(String resourceGroupName, String circuitName, String peeringName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (circuitName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter circuitName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, circuitName, peeringName, "2025-01-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExpressRouteCircuitPeeringInner> getAsync(String resourceGroupName, String circuitName, String peeringName) {
        return this.getWithResponseAsync(resourceGroupName, circuitName, peeringName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ExpressRouteCircuitPeeringInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExpressRouteCircuitPeeringInner> getWithResponse(String resourceGroupName, String circuitName, String peeringName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, circuitName, peeringName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExpressRouteCircuitPeeringInner get(String resourceGroupName, String circuitName, String peeringName) {
        return (ExpressRouteCircuitPeeringInner)((Object)this.getWithResponse(resourceGroupName, circuitName, peeringName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String circuitName, String peeringName, ExpressRouteCircuitPeeringInner peeringParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (circuitName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter circuitName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (peeringParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter peeringParameters is required and cannot be null."));
        }
        peeringParameters.validate();
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, circuitName, peeringName, "2025-01-01", this.client.getSubscriptionId(), peeringParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String circuitName, String peeringName, ExpressRouteCircuitPeeringInner peeringParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (circuitName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter circuitName is required and cannot be null."));
        }
        if (peeringName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter peeringName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (peeringParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter peeringParameters is required and cannot be null."));
        }
        peeringParameters.validate();
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, circuitName, peeringName, "2025-01-01", this.client.getSubscriptionId(), peeringParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ExpressRouteCircuitPeeringInner>, ExpressRouteCircuitPeeringInner> beginCreateOrUpdateAsync(String resourceGroupName, String circuitName, String peeringName, ExpressRouteCircuitPeeringInner peeringParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, circuitName, peeringName, peeringParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ExpressRouteCircuitPeeringInner.class), (Type)((Object)ExpressRouteCircuitPeeringInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ExpressRouteCircuitPeeringInner>, ExpressRouteCircuitPeeringInner> beginCreateOrUpdateAsync(String resourceGroupName, String circuitName, String peeringName, ExpressRouteCircuitPeeringInner peeringParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, circuitName, peeringName, peeringParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ExpressRouteCircuitPeeringInner.class), (Type)((Object)ExpressRouteCircuitPeeringInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExpressRouteCircuitPeeringInner>, ExpressRouteCircuitPeeringInner> beginCreateOrUpdate(String resourceGroupName, String circuitName, String peeringName, ExpressRouteCircuitPeeringInner peeringParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, circuitName, peeringName, peeringParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExpressRouteCircuitPeeringInner>, ExpressRouteCircuitPeeringInner> beginCreateOrUpdate(String resourceGroupName, String circuitName, String peeringName, ExpressRouteCircuitPeeringInner peeringParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, circuitName, peeringName, peeringParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ExpressRouteCircuitPeeringInner> createOrUpdateAsync(String resourceGroupName, String circuitName, String peeringName, ExpressRouteCircuitPeeringInner peeringParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, circuitName, peeringName, peeringParameters).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExpressRouteCircuitPeeringInner> createOrUpdateAsync(String resourceGroupName, String circuitName, String peeringName, ExpressRouteCircuitPeeringInner peeringParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, circuitName, peeringName, peeringParameters, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExpressRouteCircuitPeeringInner createOrUpdate(String resourceGroupName, String circuitName, String peeringName, ExpressRouteCircuitPeeringInner peeringParameters) {
        return (ExpressRouteCircuitPeeringInner)((Object)this.createOrUpdateAsync(resourceGroupName, circuitName, peeringName, peeringParameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExpressRouteCircuitPeeringInner createOrUpdate(String resourceGroupName, String circuitName, String peeringName, ExpressRouteCircuitPeeringInner peeringParameters, Context context) {
        return (ExpressRouteCircuitPeeringInner)((Object)this.createOrUpdateAsync(resourceGroupName, circuitName, peeringName, peeringParameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCircuitPeeringInner>> listSinglePageAsync(String resourceGroupName, String circuitName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (circuitName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter circuitName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, circuitName, "2025-01-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExpressRouteCircuitPeeringListResult)res.getValue()).value(), ((ExpressRouteCircuitPeeringListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCircuitPeeringInner>> listSinglePageAsync(String resourceGroupName, String circuitName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (circuitName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter circuitName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, circuitName, "2025-01-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExpressRouteCircuitPeeringListResult)res.getValue()).value(), ((ExpressRouteCircuitPeeringListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ExpressRouteCircuitPeeringInner> listAsync(String resourceGroupName, String circuitName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, circuitName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ExpressRouteCircuitPeeringInner> listAsync(String resourceGroupName, String circuitName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, circuitName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ExpressRouteCircuitPeeringInner> list(String resourceGroupName, String circuitName) {
        return new PagedIterable(this.listAsync(resourceGroupName, circuitName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ExpressRouteCircuitPeeringInner> list(String resourceGroupName, String circuitName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, circuitName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCircuitPeeringInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExpressRouteCircuitPeeringListResult)res.getValue()).value(), ((ExpressRouteCircuitPeeringListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExpressRouteCircuitPeeringInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExpressRouteCircuitPeeringListResult)res.getValue()).value(), ((ExpressRouteCircuitPeeringListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementClientExpressRouteCircuitPeerings")
    public static interface ExpressRouteCircuitPeeringsService {
        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="circuitName") String var3, @PathParam(value="peeringName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExpressRouteCircuitPeeringInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="circuitName") String var3, @PathParam(value="peeringName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings/{peeringName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="circuitName") String var3, @PathParam(value="peeringName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") ExpressRouteCircuitPeeringInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteCircuits/{circuitName}/peerings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExpressRouteCircuitPeeringListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="circuitName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExpressRouteCircuitPeeringListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

