/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ManagedRuleSetRuleGroup
implements JsonSerializable<ManagedRuleSetRuleGroup> {
    private String ruleGroupName;
    private List<String> rules;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedRuleSetRuleGroup.class);

    public String ruleGroupName() {
        return this.ruleGroupName;
    }

    public ManagedRuleSetRuleGroup withRuleGroupName(String ruleGroupName) {
        this.ruleGroupName = ruleGroupName;
        return this;
    }

    public List<String> rules() {
        return this.rules;
    }

    public ManagedRuleSetRuleGroup withRules(List<String> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.ruleGroupName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ruleGroupName in model ManagedRuleSetRuleGroup"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleGroupName", this.ruleGroupName);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedRuleSetRuleGroup fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedRuleSetRuleGroup)jsonReader.readObject(reader -> {
            ManagedRuleSetRuleGroup deserializedManagedRuleSetRuleGroup = new ManagedRuleSetRuleGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleGroupName".equals(fieldName)) {
                    deserializedManagedRuleSetRuleGroup.ruleGroupName = reader.getString();
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedManagedRuleSetRuleGroup.rules = rules = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedRuleSetRuleGroup;
        });
    }
}

