/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ScopeConnectionState;
import java.io.IOException;

public final class ScopeConnectionProperties
implements JsonSerializable<ScopeConnectionProperties> {
    private String tenantId;
    private String resourceId;
    private ScopeConnectionState connectionState;
    private String description;

    public String tenantId() {
        return this.tenantId;
    }

    public ScopeConnectionProperties withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ScopeConnectionProperties withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public ScopeConnectionState connectionState() {
        return this.connectionState;
    }

    public String description() {
        return this.description;
    }

    public ScopeConnectionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ScopeConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ScopeConnectionProperties)jsonReader.readObject(reader -> {
            ScopeConnectionProperties deserializedScopeConnectionProperties = new ScopeConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tenantId".equals(fieldName)) {
                    deserializedScopeConnectionProperties.tenantId = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedScopeConnectionProperties.resourceId = reader.getString();
                    continue;
                }
                if ("connectionState".equals(fieldName)) {
                    deserializedScopeConnectionProperties.connectionState = ScopeConnectionState.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedScopeConnectionProperties.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScopeConnectionProperties;
        });
    }
}

