/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CircuitConnectionStatus;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class PeerExpressRouteCircuitConnectionPropertiesFormat
implements JsonSerializable<PeerExpressRouteCircuitConnectionPropertiesFormat> {
    private SubResource expressRouteCircuitPeering;
    private SubResource peerExpressRouteCircuitPeering;
    private String addressPrefix;
    private CircuitConnectionStatus circuitConnectionStatus;
    private String connectionName;
    private String authResourceGuid;
    private ProvisioningState provisioningState;

    public SubResource expressRouteCircuitPeering() {
        return this.expressRouteCircuitPeering;
    }

    public PeerExpressRouteCircuitConnectionPropertiesFormat withExpressRouteCircuitPeering(SubResource expressRouteCircuitPeering) {
        this.expressRouteCircuitPeering = expressRouteCircuitPeering;
        return this;
    }

    public SubResource peerExpressRouteCircuitPeering() {
        return this.peerExpressRouteCircuitPeering;
    }

    public PeerExpressRouteCircuitConnectionPropertiesFormat withPeerExpressRouteCircuitPeering(SubResource peerExpressRouteCircuitPeering) {
        this.peerExpressRouteCircuitPeering = peerExpressRouteCircuitPeering;
        return this;
    }

    public String addressPrefix() {
        return this.addressPrefix;
    }

    public PeerExpressRouteCircuitConnectionPropertiesFormat withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    public CircuitConnectionStatus circuitConnectionStatus() {
        return this.circuitConnectionStatus;
    }

    public String connectionName() {
        return this.connectionName;
    }

    public PeerExpressRouteCircuitConnectionPropertiesFormat withConnectionName(String connectionName) {
        this.connectionName = connectionName;
        return this;
    }

    public String authResourceGuid() {
        return this.authResourceGuid;
    }

    public PeerExpressRouteCircuitConnectionPropertiesFormat withAuthResourceGuid(String authResourceGuid) {
        this.authResourceGuid = authResourceGuid;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("expressRouteCircuitPeering", (JsonSerializable)this.expressRouteCircuitPeering);
        jsonWriter.writeJsonField("peerExpressRouteCircuitPeering", (JsonSerializable)this.peerExpressRouteCircuitPeering);
        jsonWriter.writeStringField("addressPrefix", this.addressPrefix);
        jsonWriter.writeStringField("connectionName", this.connectionName);
        jsonWriter.writeStringField("authResourceGuid", this.authResourceGuid);
        return jsonWriter.writeEndObject();
    }

    public static PeerExpressRouteCircuitConnectionPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (PeerExpressRouteCircuitConnectionPropertiesFormat)jsonReader.readObject(reader -> {
            PeerExpressRouteCircuitConnectionPropertiesFormat deserializedPeerExpressRouteCircuitConnectionPropertiesFormat = new PeerExpressRouteCircuitConnectionPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expressRouteCircuitPeering".equals(fieldName)) {
                    deserializedPeerExpressRouteCircuitConnectionPropertiesFormat.expressRouteCircuitPeering = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("peerExpressRouteCircuitPeering".equals(fieldName)) {
                    deserializedPeerExpressRouteCircuitConnectionPropertiesFormat.peerExpressRouteCircuitPeering = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("addressPrefix".equals(fieldName)) {
                    deserializedPeerExpressRouteCircuitConnectionPropertiesFormat.addressPrefix = reader.getString();
                    continue;
                }
                if ("circuitConnectionStatus".equals(fieldName)) {
                    deserializedPeerExpressRouteCircuitConnectionPropertiesFormat.circuitConnectionStatus = CircuitConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("connectionName".equals(fieldName)) {
                    deserializedPeerExpressRouteCircuitConnectionPropertiesFormat.connectionName = reader.getString();
                    continue;
                }
                if ("authResourceGuid".equals(fieldName)) {
                    deserializedPeerExpressRouteCircuitConnectionPropertiesFormat.authResourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedPeerExpressRouteCircuitConnectionPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPeerExpressRouteCircuitConnectionPropertiesFormat;
        });
    }
}

