/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkGroupInner;
import java.io.IOException;
import java.util.List;

public final class NetworkGroupListResult
implements JsonSerializable<NetworkGroupListResult> {
    private List<NetworkGroupInner> value;
    private String nextLink;

    public List<NetworkGroupInner> value() {
        return this.value;
    }

    public NetworkGroupListResult withValue(List<NetworkGroupInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public NetworkGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static NetworkGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkGroupListResult)jsonReader.readObject(reader -> {
            NetworkGroupListResult deserializedNetworkGroupListResult = new NetworkGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedNetworkGroupListResult.value = value = reader.readArray(reader1 -> NetworkGroupInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedNetworkGroupListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkGroupListResult;
        });
    }
}

