/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CircuitConnectionStatus;
import com.azure.resourcemanager.network.models.Ipv6CircuitConnectionConfig;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ExpressRouteCircuitConnectionPropertiesFormat
implements JsonSerializable<ExpressRouteCircuitConnectionPropertiesFormat> {
    private SubResource expressRouteCircuitPeering;
    private SubResource peerExpressRouteCircuitPeering;
    private String addressPrefix;
    private String authorizationKey;
    private Ipv6CircuitConnectionConfig ipv6CircuitConnectionConfig;
    private CircuitConnectionStatus circuitConnectionStatus;
    private ProvisioningState provisioningState;

    public SubResource expressRouteCircuitPeering() {
        return this.expressRouteCircuitPeering;
    }

    public ExpressRouteCircuitConnectionPropertiesFormat withExpressRouteCircuitPeering(SubResource expressRouteCircuitPeering) {
        this.expressRouteCircuitPeering = expressRouteCircuitPeering;
        return this;
    }

    public SubResource peerExpressRouteCircuitPeering() {
        return this.peerExpressRouteCircuitPeering;
    }

    public ExpressRouteCircuitConnectionPropertiesFormat withPeerExpressRouteCircuitPeering(SubResource peerExpressRouteCircuitPeering) {
        this.peerExpressRouteCircuitPeering = peerExpressRouteCircuitPeering;
        return this;
    }

    public String addressPrefix() {
        return this.addressPrefix;
    }

    public ExpressRouteCircuitConnectionPropertiesFormat withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    public String authorizationKey() {
        return this.authorizationKey;
    }

    public ExpressRouteCircuitConnectionPropertiesFormat withAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    public Ipv6CircuitConnectionConfig ipv6CircuitConnectionConfig() {
        return this.ipv6CircuitConnectionConfig;
    }

    public ExpressRouteCircuitConnectionPropertiesFormat withIpv6CircuitConnectionConfig(Ipv6CircuitConnectionConfig ipv6CircuitConnectionConfig) {
        this.ipv6CircuitConnectionConfig = ipv6CircuitConnectionConfig;
        return this;
    }

    public CircuitConnectionStatus circuitConnectionStatus() {
        return this.circuitConnectionStatus;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.ipv6CircuitConnectionConfig() != null) {
            this.ipv6CircuitConnectionConfig().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("expressRouteCircuitPeering", (JsonSerializable)this.expressRouteCircuitPeering);
        jsonWriter.writeJsonField("peerExpressRouteCircuitPeering", (JsonSerializable)this.peerExpressRouteCircuitPeering);
        jsonWriter.writeStringField("addressPrefix", this.addressPrefix);
        jsonWriter.writeStringField("authorizationKey", this.authorizationKey);
        jsonWriter.writeJsonField("ipv6CircuitConnectionConfig", (JsonSerializable)this.ipv6CircuitConnectionConfig);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteCircuitConnectionPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteCircuitConnectionPropertiesFormat)jsonReader.readObject(reader -> {
            ExpressRouteCircuitConnectionPropertiesFormat deserializedExpressRouteCircuitConnectionPropertiesFormat = new ExpressRouteCircuitConnectionPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("expressRouteCircuitPeering".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionPropertiesFormat.expressRouteCircuitPeering = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("peerExpressRouteCircuitPeering".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionPropertiesFormat.peerExpressRouteCircuitPeering = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("addressPrefix".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionPropertiesFormat.addressPrefix = reader.getString();
                    continue;
                }
                if ("authorizationKey".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionPropertiesFormat.authorizationKey = reader.getString();
                    continue;
                }
                if ("ipv6CircuitConnectionConfig".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionPropertiesFormat.ipv6CircuitConnectionConfig = Ipv6CircuitConnectionConfig.fromJson(reader);
                    continue;
                }
                if ("circuitConnectionStatus".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionPropertiesFormat.circuitConnectionStatus = CircuitConnectionStatus.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRouteCircuitConnectionPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteCircuitConnectionPropertiesFormat;
        });
    }
}

