/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointInner;
import com.azure.resourcemanager.network.models.CustomDnsConfigPropertiesFormat;
import com.azure.resourcemanager.network.models.PrivateDnsZoneGroups;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.network.models.PrivateLinkSubResourceName;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ChildResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Attachable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Settable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Map;

public interface PrivateEndpoint
extends GroupableResource<NetworkManager, PrivateEndpointInner>,
Refreshable<PrivateEndpoint>,
Updatable<Update> {
    public PrivateDnsZoneGroups privateDnsZoneGroups();

    public SubResource subnet();

    public List<SubResource> networkInterfaces();

    public ProvisioningState provisioningState();

    public Map<String, PrivateLinkServiceConnection> privateLinkServiceConnections();

    public List<CustomDnsConfigPropertiesFormat> customDnsConfigurations();

    public static interface UpdateStages {

        public static interface WithPrivateLinkServiceConnection {
            public Update withoutPrivateLinkServiceConnection(String var1);

            public PrivateLinkServiceConnection.DefinitionStages.Blank<? extends Update> definePrivateLinkServiceConnection(String var1);

            public PrivateLinkServiceConnection.Update updatePrivateLinkServiceConnection(String var1);
        }
    }

    public static interface Update
    extends Appliable<PrivateEndpoint>,
    UpdateStages.WithPrivateLinkServiceConnection,
    Resource.UpdateWithTags<Update> {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<PrivateEndpoint> {
        }

        public static interface WithPrivateLinkServiceConnection {
            public PrivateLinkServiceConnection.DefinitionStages.Blank<? extends WithCreate> definePrivateLinkServiceConnection(String var1);
        }

        public static interface WithSubnet {
            public WithPrivateLinkServiceConnection withSubnet(Subnet var1);

            public WithPrivateLinkServiceConnection withSubnetId(String var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSubnet> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSubnet,
    DefinitionStages.WithPrivateLinkServiceConnection,
    DefinitionStages.WithCreate {
    }

    public static interface PrivateLinkServiceConnection
    extends HasInnerModel<com.azure.resourcemanager.network.models.PrivateLinkServiceConnection>,
    ChildResource<PrivateEndpoint> {
        public PrivateLinkServiceConnectionState state();

        public String privateLinkResourceId();

        public List<PrivateLinkSubResourceName> subResourceNames();

        public String requestMessage();

        public ProvisioningState provisioningState();

        public boolean isManualApproval();

        public static interface Update
        extends UpdateStages.WithApprovalMethod,
        Settable<com.azure.resourcemanager.network.models.PrivateEndpoint$Update> {
        }

        public static interface UpdateStages {

            public static interface WithApprovalMethod {
                public Update withRequestMessage(String var1);
            }
        }

        public static interface Definition<ParentT>
        extends DefinitionStages.Blank<ParentT>,
        DefinitionStages.WithPrivateLinkServiceResource<ParentT>,
        DefinitionStages.WithSubResource<ParentT>,
        DefinitionStages.WithApprovalMethod<ParentT>,
        DefinitionStages.WithAttach<ParentT> {
        }

        public static interface DefinitionStages {

            public static interface WithAttach<ParentT>
            extends Attachable.InDefinition<ParentT>,
            WithApprovalMethod<ParentT> {
            }

            public static interface WithApprovalMethod<ParentT> {
                public WithAttach<ParentT> withManualApproval(String var1);
            }

            public static interface WithSubResource<ParentT> {
                public WithAttach<ParentT> withSubResource(PrivateLinkSubResourceName var1);

                public WithAttach<ParentT> withoutSubResource();
            }

            public static interface WithPrivateLinkServiceResource<ParentT> {
                public WithSubResource<ParentT> withResource(Resource var1);

                public WithSubResource<ParentT> withResourceId(String var1);
            }

            public static interface Blank<ParentT>
            extends WithPrivateLinkServiceResource<ParentT> {
            }
        }
    }
}

