/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayProbeHealthResponseMatch;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ApplicationGatewayProbePropertiesFormat
implements JsonSerializable<ApplicationGatewayProbePropertiesFormat> {
    private ApplicationGatewayProtocol protocol;
    private String host;
    private String path;
    private Integer interval;
    private Integer timeout;
    private Integer unhealthyThreshold;
    private Boolean pickHostnameFromBackendHttpSettings;
    private Boolean pickHostnameFromBackendSettings;
    private Integer minServers;
    private ApplicationGatewayProbeHealthResponseMatch match;
    private ProvisioningState provisioningState;
    private Integer port;

    public ApplicationGatewayProtocol protocol() {
        return this.protocol;
    }

    public ApplicationGatewayProbePropertiesFormat withProtocol(ApplicationGatewayProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String host() {
        return this.host;
    }

    public ApplicationGatewayProbePropertiesFormat withHost(String host) {
        this.host = host;
        return this;
    }

    public String path() {
        return this.path;
    }

    public ApplicationGatewayProbePropertiesFormat withPath(String path) {
        this.path = path;
        return this;
    }

    public Integer interval() {
        return this.interval;
    }

    public ApplicationGatewayProbePropertiesFormat withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public ApplicationGatewayProbePropertiesFormat withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public Integer unhealthyThreshold() {
        return this.unhealthyThreshold;
    }

    public ApplicationGatewayProbePropertiesFormat withUnhealthyThreshold(Integer unhealthyThreshold) {
        this.unhealthyThreshold = unhealthyThreshold;
        return this;
    }

    public Boolean pickHostnameFromBackendHttpSettings() {
        return this.pickHostnameFromBackendHttpSettings;
    }

    public ApplicationGatewayProbePropertiesFormat withPickHostnameFromBackendHttpSettings(Boolean pickHostnameFromBackendHttpSettings) {
        this.pickHostnameFromBackendHttpSettings = pickHostnameFromBackendHttpSettings;
        return this;
    }

    public Boolean pickHostnameFromBackendSettings() {
        return this.pickHostnameFromBackendSettings;
    }

    public ApplicationGatewayProbePropertiesFormat withPickHostnameFromBackendSettings(Boolean pickHostnameFromBackendSettings) {
        this.pickHostnameFromBackendSettings = pickHostnameFromBackendSettings;
        return this;
    }

    public Integer minServers() {
        return this.minServers;
    }

    public ApplicationGatewayProbePropertiesFormat withMinServers(Integer minServers) {
        this.minServers = minServers;
        return this;
    }

    public ApplicationGatewayProbeHealthResponseMatch match() {
        return this.match;
    }

    public ApplicationGatewayProbePropertiesFormat withMatch(ApplicationGatewayProbeHealthResponseMatch match) {
        this.match = match;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Integer port() {
        return this.port;
    }

    public ApplicationGatewayProbePropertiesFormat withPort(Integer port) {
        this.port = port;
        return this;
    }

    public void validate() {
        if (this.match() != null) {
            this.match().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeStringField("host", this.host);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeNumberField("interval", (Number)this.interval);
        jsonWriter.writeNumberField("timeout", (Number)this.timeout);
        jsonWriter.writeNumberField("unhealthyThreshold", (Number)this.unhealthyThreshold);
        jsonWriter.writeBooleanField("pickHostNameFromBackendHttpSettings", this.pickHostnameFromBackendHttpSettings);
        jsonWriter.writeBooleanField("pickHostNameFromBackendSettings", this.pickHostnameFromBackendSettings);
        jsonWriter.writeNumberField("minServers", (Number)this.minServers);
        jsonWriter.writeJsonField("match", (JsonSerializable)this.match);
        jsonWriter.writeNumberField("port", (Number)this.port);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayProbePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayProbePropertiesFormat)jsonReader.readObject(reader -> {
            ApplicationGatewayProbePropertiesFormat deserializedApplicationGatewayProbePropertiesFormat = new ApplicationGatewayProbePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("protocol".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.protocol = ApplicationGatewayProtocol.fromString(reader.getString());
                    continue;
                }
                if ("host".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.host = reader.getString();
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.path = reader.getString();
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.interval = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.timeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("unhealthyThreshold".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.unhealthyThreshold = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("pickHostNameFromBackendHttpSettings".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.pickHostnameFromBackendHttpSettings = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("pickHostNameFromBackendSettings".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.pickHostnameFromBackendSettings = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("minServers".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.minServers = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("match".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.match = ApplicationGatewayProbeHealthResponseMatch.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedApplicationGatewayProbePropertiesFormat.port = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayProbePropertiesFormat;
        });
    }
}

