/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.FirewallPolicyFilterRuleCollection;
import com.azure.resourcemanager.network.models.FirewallPolicyNatRuleCollection;
import com.azure.resourcemanager.network.models.FirewallPolicyRuleCollectionType;
import java.io.IOException;

public class FirewallPolicyRuleCollection
implements JsonSerializable<FirewallPolicyRuleCollection> {
    private FirewallPolicyRuleCollectionType ruleCollectionType = FirewallPolicyRuleCollectionType.fromString("FirewallPolicyRuleCollection");
    private String name;
    private Integer priority;

    public FirewallPolicyRuleCollectionType ruleCollectionType() {
        return this.ruleCollectionType;
    }

    public String name() {
        return this.name;
    }

    public FirewallPolicyRuleCollection withName(String name) {
        this.name = name;
        return this;
    }

    public Integer priority() {
        return this.priority;
    }

    public FirewallPolicyRuleCollection withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleCollectionType", this.ruleCollectionType == null ? null : this.ruleCollectionType.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        return jsonWriter.writeEndObject();
    }

    public static FirewallPolicyRuleCollection fromJson(JsonReader jsonReader) throws IOException {
        return (FirewallPolicyRuleCollection)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                FirewallPolicyRuleCollection firewallPolicyRuleCollection;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("ruleCollectionType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("FirewallPolicyNatRuleCollection".equals(discriminatorValue)) {
                    firewallPolicyRuleCollection = FirewallPolicyNatRuleCollection.fromJson(readerToUse.reset());
                    return firewallPolicyRuleCollection;
                }
                if ("FirewallPolicyFilterRuleCollection".equals(discriminatorValue)) {
                    firewallPolicyRuleCollection = FirewallPolicyFilterRuleCollection.fromJson(readerToUse.reset());
                    return firewallPolicyRuleCollection;
                }
                firewallPolicyRuleCollection = FirewallPolicyRuleCollection.fromJsonKnownDiscriminator(readerToUse.reset());
                return firewallPolicyRuleCollection;
            }
        });
    }

    static FirewallPolicyRuleCollection fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (FirewallPolicyRuleCollection)jsonReader.readObject(reader -> {
            FirewallPolicyRuleCollection deserializedFirewallPolicyRuleCollection = new FirewallPolicyRuleCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleCollectionType".equals(fieldName)) {
                    deserializedFirewallPolicyRuleCollection.ruleCollectionType = FirewallPolicyRuleCollectionType.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFirewallPolicyRuleCollection.name = reader.getString();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedFirewallPolicyRuleCollection.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFirewallPolicyRuleCollection;
        });
    }
}

