/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConnectionMonitorWorkspaceSettings;
import com.azure.resourcemanager.network.models.OutputType;
import java.io.IOException;

public final class ConnectionMonitorOutput
implements JsonSerializable<ConnectionMonitorOutput> {
    private OutputType type;
    private ConnectionMonitorWorkspaceSettings workspaceSettings;

    public OutputType type() {
        return this.type;
    }

    public ConnectionMonitorOutput withType(OutputType type) {
        this.type = type;
        return this;
    }

    public ConnectionMonitorWorkspaceSettings workspaceSettings() {
        return this.workspaceSettings;
    }

    public ConnectionMonitorOutput withWorkspaceSettings(ConnectionMonitorWorkspaceSettings workspaceSettings) {
        this.workspaceSettings = workspaceSettings;
        return this;
    }

    public void validate() {
        if (this.workspaceSettings() != null) {
            this.workspaceSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("workspaceSettings", (JsonSerializable)this.workspaceSettings);
        return jsonWriter.writeEndObject();
    }

    public static ConnectionMonitorOutput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectionMonitorOutput)jsonReader.readObject(reader -> {
            ConnectionMonitorOutput deserializedConnectionMonitorOutput = new ConnectionMonitorOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedConnectionMonitorOutput.type = OutputType.fromString(reader.getString());
                    continue;
                }
                if ("workspaceSettings".equals(fieldName)) {
                    deserializedConnectionMonitorOutput.workspaceSettings = ConnectionMonitorWorkspaceSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectionMonitorOutput;
        });
    }
}

