/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.Parameter;
import com.azure.resourcemanager.network.models.RouteMapActionType;
import java.io.IOException;
import java.util.List;

public final class Action
implements JsonSerializable<Action> {
    private RouteMapActionType type;
    private List<Parameter> parameters;

    public RouteMapActionType type() {
        return this.type;
    }

    public Action withType(RouteMapActionType type) {
        this.type = type;
        return this;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Action withParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static Action fromJson(JsonReader jsonReader) throws IOException {
        return (Action)jsonReader.readObject(reader -> {
            Action deserializedAction = new Action();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedAction.type = RouteMapActionType.fromString(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedAction.parameters = parameters = reader.readArray(reader1 -> Parameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAction;
        });
    }
}

