/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualHubRouteV2;
import java.io.IOException;
import java.util.List;

public final class VirtualHubRouteTableV2Properties
implements JsonSerializable<VirtualHubRouteTableV2Properties> {
    private List<VirtualHubRouteV2> routes;
    private List<String> attachedConnections;
    private ProvisioningState provisioningState;

    public List<VirtualHubRouteV2> routes() {
        return this.routes;
    }

    public VirtualHubRouteTableV2Properties withRoutes(List<VirtualHubRouteV2> routes) {
        this.routes = routes;
        return this;
    }

    public List<String> attachedConnections() {
        return this.attachedConnections;
    }

    public VirtualHubRouteTableV2Properties withAttachedConnections(List<String> attachedConnections) {
        this.attachedConnections = attachedConnections;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.routes() != null) {
            this.routes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("routes", this.routes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("attachedConnections", this.attachedConnections, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualHubRouteTableV2Properties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualHubRouteTableV2Properties)jsonReader.readObject(reader -> {
            VirtualHubRouteTableV2Properties deserializedVirtualHubRouteTableV2Properties = new VirtualHubRouteTableV2Properties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("routes".equals(fieldName)) {
                    List routes;
                    deserializedVirtualHubRouteTableV2Properties.routes = routes = reader.readArray(reader1 -> VirtualHubRouteV2.fromJson(reader1));
                    continue;
                }
                if ("attachedConnections".equals(fieldName)) {
                    List attachedConnections;
                    deserializedVirtualHubRouteTableV2Properties.attachedConnections = attachedConnections = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualHubRouteTableV2Properties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualHubRouteTableV2Properties;
        });
    }
}

